package com.temboo.Library.SunlightLabs.CapitolWords;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FullTextSearch

Returns a list of Congressional Record documents in which the given phrase appears.
*/
public class FullTextSearch extends Choreography {

	/**
	Create a new instance of the FullTextSearch Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FullTextSearch(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/SunlightLabs/CapitolWords/FullTextSearch"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FullTextSearchInputSet
	*/
	public FullTextSearchInputSet newInputSet() {
		return new FullTextSearchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FullTextSearchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FullTextSearchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FullTextSearch
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FullTextSearchInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Sunlight Labs.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the BioguideID input for this Choreo. 

		@param String - (optional, string) Limit results to the member of Congress with the given Bioguide ID. The Bioguide ID of any current or past congressonal member can be found at bioguide.congress.gov.
		*/
		public void set_BioguideID(String value) {
			this.setInput("BioguideID", value);
		}


		/** 
		Set the value of the CRPages input for this Choreo. 

		@param String - (optional, string) The pages in the Congressional Record to search.
		*/
		public void set_CRPages(String value) {
			this.setInput("CRPages", value);
		}


		/** 
		Set the value of the Chamber input for this Choreo. 

		@param String - (optional, string) Limit results to a particular chamber. Valid values: house, senate, extensions.
		*/
		public void set_Chamber(String value) {
			this.setInput("Chamber", value);
		}


		/** 
		Set the value of the Date input for this Choreo. 

		@param String - (optional, string) Show results for only the given date. Format: YYYY-MM-DD
		*/
		public void set_Date(String value) {
			this.setInput("Date", value);
		}


		/** 
		Set the value of the EndDate input for this Choreo. 

		@param String - (optional, string) Limit results to those on or before the given date. Format: YYYY-MM-DD.
		*/
		public void set_EndDate(String value) {
			this.setInput("EndDate", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page of results to show. 100 shown at a time.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page of results to show. 100 shown at a time.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the Party input for this Choreo. 

		@param String - (optional, string) Limit results to members of congress from a given party. Valid values: R, D, I.
		*/
		public void set_Party(String value) {
			this.setInput("Party", value);
		}


		/** 
		Set the value of the Phrase input for this Choreo. 

		@param String - (required, string) A phrase to search the body of each Congressional Record document for. Either Phrase or Title inputs are required.
		*/
		public void set_Phrase(String value) {
			this.setInput("Phrase", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Output formats inlcude json and xml. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the StartDate input for this Choreo. 

		@param String - (optional, string) Limit results to those on or after the given date. Format: YYYY-MM-DD
		*/
		public void set_StartDate(String value) {
			this.setInput("StartDate", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) Limit results to members from a particular state. Format: 2-letter state abbreviation (e.g. MD, RI, NY)
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the Title input for this Choreo. 

		@param Integer - (optional, integer) A phrase to search the title of each Congressional Record document for. Either Phrase or Title are required.
		*/
		public void set_Title(Integer value) {
			this.setInput("Title", value);
		}

		/** 
		Set the value of the Title input for this Choreo as a String. 

		@param String - (optional, integer) A phrase to search the title of each Congressional Record document for. Either Phrase or Title are required.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FullTextSearch Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FullTextSearchResultSet extends ResultSet {
		public FullTextSearchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from CapitolWords.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
