package com.temboo.Library.Stripe.InvoiceItems;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateInvoiceItem

Adds a charge or credit to the customer's next invoice.
*/
public class CreateInvoiceItem extends Choreography {

	/**
	Create a new instance of the CreateInvoiceItem Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateInvoiceItem(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Stripe/InvoiceItems/CreateInvoiceItem"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateInvoiceItemInputSet
	*/
	public CreateInvoiceItemInputSet newInputSet() {
		return new CreateInvoiceItemInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateInvoiceItemResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateInvoiceItemResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateInvoiceItem
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateInvoiceItemInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key providied by Stripe
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Amount input for this Choreo. 

		@param Integer - (required, integer) The amount in cents of the charge to be included in the customer's next invoice
		*/
		public void set_Amount(Integer value) {
			this.setInput("Amount", value);
		}

		/** 
		Set the value of the Amount input for this Choreo as a String. 

		@param String - (required, integer) The amount in cents of the charge to be included in the customer's next invoice
		*/
		public void set_Amount(String value) {
			this.setInput("Amount", value);	
		}
		/** 
		Set the value of the Currency input for this Choreo. 

		@param String - (optional, string) 3-letter ISO code for currency. Defaults to 'usd' which is currently the only supported currency.
		*/
		public void set_Currency(String value) {
			this.setInput("Currency", value);
		}


		/** 
		Set the value of the CustomerID input for this Choreo. 

		@param String - (required, string) The unique identifier of the customer you want to create an invoice item for
		*/
		public void set_CustomerID(String value) {
			this.setInput("CustomerID", value);
		}


		/** 
		Set the value of the Description input for this Choreo. 

		@param String - (optional, string) An arbitrary string of text that will be included with the invoice item
		*/
		public void set_Description(String value) {
			this.setInput("Description", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateInvoiceItem Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateInvoiceItemResultSet extends ResultSet {
		public CreateInvoiceItemResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Stripe
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
