package com.temboo.Library.Socrata.SODA;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Query

Performs queries against data on the Socrata Platform.
*/
public class Query extends Choreography {

	/**
	Create a new instance of the Query Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Query(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Socrata/SODA/Query"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return QueryInputSet
	*/
	public QueryInputSet newInputSet() {
		return new QueryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public QueryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new QueryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Query
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class QueryInputSet extends InputSet {
		/** 
		Set the value of the AppToken input for this Choreo. 

		@param String - (optional, string) The App Token provided by Socrata.
		*/
		public void set_AppToken(String value) {
			this.setInput("AppToken", value);
		}


		/** 
		Set the value of the Domain input for this Choreo. 

		@param String - (required, string) The domain used in the request (i.e. soda.demo.socrata.com).
		*/
		public void set_Domain(String value) {
			this.setInput("Domain", value);
		}


		/** 
		Set the value of the Group input for this Choreo. 

		@param String - (optional, string) Groups results based on the column name provided.
		*/
		public void set_Group(String value) {
			this.setInput("Group", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param String - (optional, string) The maximum number of results to return. Used in combination with the Offset input for pagination. Defaults to 100.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);
		}


		/** 
		Set the value of the Offset input for this Choreo. 

		@param String - (optional, string) Indicates the starting point of the result set. Used in combination with the Limit input for pagination. Defaults to 0.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);
		}


		/** 
		Set the value of the Order input for this Choreo. 

		@param String - (optional, string) Determines how results will be sorted. This input can take a column name, and can sort in either ascending or descending order (i.e. datetime asc).
		*/
		public void set_Order(String value) {
			this.setInput("Order", value);
		}


		/** 
		Set the value of the Resource input for this Choreo. 

		@param String - (required, string) The unique identifier for a dataset to retrieve (i.e 4tka-6guv or earthquakes).
		*/
		public void set_Resource(String value) {
			this.setInput("Resource", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default), xml, csv, and rdf.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Search input for this Choreo. 

		@param String - (optional, string) A search clause. This wll do a full text search for a value.
		*/
		public void set_Search(String value) {
			this.setInput("Search", value);
		}


		/** 
		Set the value of the Select input for this Choreo. 

		@param String - (optional, string) Indicates which columns to return. If not specified, all columns will be returned.
		*/
		public void set_Select(String value) {
			this.setInput("Select", value);
		}


		/** 
		Set the value of the Where input for this Choreo. 

		@param String - (optional, string) Filters the results using a WHERE clause.
		*/
		public void set_Where(String value) {
			this.setInput("Where", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Query Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class QueryResultSet extends ResultSet {
		public QueryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Fields" output from this Choreo execution

		@return String - (json) This lists the fields returned in this response in a JSON array.
		*/
		public String get_Fields() {
			return this.getResultString("Fields");
		}
		/** 
		Retrieve the value for the "Types" output from this Choreo execution

		@return String - (json) This is a list of SODA2 types in a JSON array. These will match up in the same order as the fields in X-SODA2-Fields.
		*/
		public String get_Types() {
			return this.getResultString("Types");
		}
		/** 
		Retrieve the value for the "LastModified" output from this Choreo execution

		@return String - (date) Contains the date returned in the Last-Modified response header.
		*/
		public String get_LastModified() {
			return this.getResultString("LastModified");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response form Socrata.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
