package com.temboo.Library.RunKeeper.GeneralMeasurements;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateEntry

Updates a body measurement entry in a user’s feed.
*/
public class UpdateEntry extends Choreography {

	/**
	Create a new instance of the UpdateEntry Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateEntry(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/RunKeeper/GeneralMeasurements/UpdateEntry"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateEntryInputSet
	*/
	public UpdateEntryInputSet newInputSet() {
		return new UpdateEntryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateEntryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateEntryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateEntry
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateEntryInputSet extends InputSet {
		/** 
		Set the value of the Entry input for this Choreo. 

		@param String - (required, json) A JSON string containing the key/value pairs for the fields to be updated in the body measurement entry. See documentation for formatting examples.
		*/
		public void set_Entry(String value) {
			this.setInput("Entry", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved after the final step in the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the EntryID input for this Choreo. 

		@param String - (required, string) This can be the individual id of the body measurement entry, or you can pass the full uri for the entry as returned from the RetrieveEntries Choreo (i.e. /generalMeasurements/24085455).
		*/
		public void set_EntryID(String value) {
			this.setInput("EntryID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateEntry Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateEntryResultSet extends ResultSet {
		public UpdateEntryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from RunKeeper.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
