package com.temboo.Library.PayPal.Payments;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
VerifyCreditCardPayment

Verifies that a credit card payment from the PayPal REST API has been completed successfully.
*/
public class VerifyCreditCardPayment extends Choreography {

	/**
	Create a new instance of the VerifyCreditCardPayment Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public VerifyCreditCardPayment(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PayPal/Payments/VerifyCreditCardPayment"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return VerifyCreditCardPaymentInputSet
	*/
	public VerifyCreditCardPaymentInputSet newInputSet() {
		return new VerifyCreditCardPaymentInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public VerifyCreditCardPaymentResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new VerifyCreditCardPaymentResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the VerifyCreditCardPayment
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class VerifyCreditCardPaymentInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved from PayPal. Required unless providing the ClientID and ClientSecret which can be used to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by PayPal. This is used to authenticate PayPal's REST API.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by PayPal. This is used to authenticate PayPal's REST API.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the ProofOfPayment input for this Choreo. 

		@param String - (conditional, json) The proof of payment received from the client SDK. This can be a proof of payment received from the Adaptive Payment API or the REST API.
		*/
		public void set_ProofOfPayment(String value) {
			this.setInput("ProofOfPayment", value);
		}


		/** 
		Set the value of the UseSandbox input for this Choreo. 

		@param Boolean - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(Boolean value) {
			this.setInput("UseSandbox", value);
		}

		/** 
		Set the value of the UseSandbox input for this Choreo as a String. 

		@param String - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(String value) {
			this.setInput("UseSandbox", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the VerifyCreditCardPayment Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class VerifyCreditCardPaymentResultSet extends ResultSet {
		public VerifyCreditCardPaymentResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "FailureDescription" output from this Choreo execution

		@return String - (json) When the payment details indicate that the payment status is not complete, this will contain a JSON dictionary of payment status descriptions.
		*/
		public String get_FailureDescription() {
			return this.getResultString("FailureDescription");
		}
		/** 
		Retrieve the value for the "VerificationStatus" output from this Choreo execution

		@return String - (string) The status of the payment verification. This will set to either "verified" or "unverified" depending on the status of the payment details.
		*/
		public String get_VerificationStatus() {
			return this.getResultString("VerificationStatus");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from PayPal. This includes the full response from retrieving payment details from the Rest API.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
