package com.temboo.Library.PagerDuty.LogEntries;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListLogEntriesByIncident

Lists all incident log entries associated with a specific incident.
*/
public class ListLogEntriesByIncident extends Choreography {

	/**
	Create a new instance of the ListLogEntriesByIncident Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListLogEntriesByIncident(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PagerDuty/LogEntries/ListLogEntriesByIncident"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListLogEntriesByIncidentInputSet
	*/
	public ListLogEntriesByIncidentInputSet newInputSet() {
		return new ListLogEntriesByIncidentInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListLogEntriesByIncidentResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListLogEntriesByIncidentResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListLogEntriesByIncident
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListLogEntriesByIncidentInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by PagerDuty.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the IncidentID input for this Choreo. 

		@param String - (required, string) The ID of the incident associated with the log entries to retrieve.
		*/
		public void set_IncidentID(String value) {
			this.setInput("IncidentID", value);
		}


		/** 
		Set the value of the Include input for this Choreo. 

		@param String - (optional, string) A list of additional details to include in the response. Valid values are: channel, incident, and service.
		*/
		public void set_Include(String value) {
			this.setInput("Include", value);
		}


		/** 
		Set the value of the IsOverview input for this Choreo. 

		@param Boolean - (optional, boolean) If set to true, only log entries of type trigger, acknowledge, or resolve are returned. Defaults to false.
		*/
		public void set_IsOverview(Boolean value) {
			this.setInput("IsOverview", value);
		}

		/** 
		Set the value of the IsOverview input for this Choreo as a String. 

		@param String - (optional, boolean) If set to true, only log entries of type trigger, acknowledge, or resolve are returned. Defaults to false.
		*/
		public void set_IsOverview(String value) {
			this.setInput("IsOverview", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of log events returned. Default (and max limit) is 100.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of log events returned. Default (and max limit) is 100.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) The offset of the first log event record returned. Default is 0.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) The offset of the first log event record returned. Default is 0.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the Since input for this Choreo. 

		@param String - (optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
		*/
		public void set_Since(String value) {
			this.setInput("Since", value);
		}


		/** 
		Set the value of the SubDomain input for this Choreo. 

		@param String - (required, string) The subdomain of your PagerDuty site address.
		*/
		public void set_SubDomain(String value) {
			this.setInput("SubDomain", value);
		}


		/** 
		Set the value of the TimeZone input for this Choreo. 

		@param String - (optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.
		*/
		public void set_TimeZone(String value) {
			this.setInput("TimeZone", value);
		}


		/** 
		Set the value of the Until input for this Choreo. 

		@param String - (optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
		*/
		public void set_Until(String value) {
			this.setInput("Until", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListLogEntriesByIncident Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListLogEntriesByIncidentResultSet extends ResultSet {
		public ListLogEntriesByIncidentResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from PagerDuty.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
