package com.temboo.Library.Mixpanel.Profiles;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Delete

Permanently deletes the profile from Mixpanel, along with all of its properties.
*/
public class Delete extends Choreography {

	/**
	Create a new instance of the Delete Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Delete(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Mixpanel/Profiles/Delete"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeleteInputSet
	*/
	public DeleteInputSet newInputSet() {
		return new DeleteInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeleteResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeleteResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Delete
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeleteInputSet extends InputSet {
		/** 
		Set the value of the DistinctID input for this Choreo. 

		@param String - (required, string) Used to uniquely identify the profile you want to update.
		*/
		public void set_DistinctID(String value) {
			this.setInput("DistinctID", value);
		}


		/** 
		Set the value of the Token input for this Choreo. 

		@param String - (required, string) The token provided by Mixpanel. You can find your Mixpanel token in the project settings dialog in the Mixpanel app.
		*/
		public void set_Token(String value) {
			this.setInput("Token", value);
		}


		/** 
		Set the value of the Verbose input for this Choreo. 

		@param Boolean - (optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.
		*/
		public void set_Verbose(Boolean value) {
			this.setInput("Verbose", value);
		}

		/** 
		Set the value of the Verbose input for this Choreo as a String. 

		@param String - (optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.
		*/
		public void set_Verbose(String value) {
			this.setInput("Verbose", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Delete Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeleteResultSet extends ResultSet {
		public DeleteResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Mixpanel.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
