package com.temboo.Library.LinkedIn.Companies;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetHistoricalFollowers

Returns a company's followers, by date range.
*/
public class GetHistoricalFollowers extends Choreography {

	/**
	Create a new instance of the GetHistoricalFollowers Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetHistoricalFollowers(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LinkedIn/Companies/GetHistoricalFollowers"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetHistoricalFollowersInputSet
	*/
	public GetHistoricalFollowersInputSet newInputSet() {
		return new GetHistoricalFollowersInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetHistoricalFollowersResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetHistoricalFollowersResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetHistoricalFollowers
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetHistoricalFollowersInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by LinkedIn (AKA the Client ID).
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the CompanyID input for this Choreo. 

		@param Integer - (required, integer) A LinkedIn assigned ID associated with the company.
		*/
		public void set_CompanyID(Integer value) {
			this.setInput("CompanyID", value);
		}

		/** 
		Set the value of the CompanyID input for this Choreo as a String. 

		@param String - (required, integer) A LinkedIn assigned ID associated with the company.
		*/
		public void set_CompanyID(String value) {
			this.setInput("CompanyID", value);	
		}
		/** 
		Set the value of the EndTimestamp input for this Choreo. 

		@param String - (optional, date) The starting timestamp of when the stats search should begin (milliseconds since epoch). The current time will be used if a timestamp is not provided.
		*/
		public void set_EndTimestamp(String value) {
			this.setInput("EndTimestamp", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SecretKey input for this Choreo. 

		@param String - (required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
		*/
		public void set_SecretKey(String value) {
			this.setInput("SecretKey", value);
		}


		/** 
		Set the value of the StartTimestamp input for this Choreo. 

		@param String - (required, date) The starting timestamp of when the stats search should begin (milliseconds since epoch). The current time will be used if a timestamp is not provided.
		*/
		public void set_StartTimestamp(String value) {
			this.setInput("StartTimestamp", value);
		}


		/** 
		Set the value of the TimeGranularity input for this Choreo. 

		@param String - (required, string) Granularity of statistics. Valid values are: day, month.
		*/
		public void set_TimeGranularity(String value) {
			this.setInput("TimeGranularity", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetHistoricalFollowers Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetHistoricalFollowersResultSet extends ResultSet {
		public GetHistoricalFollowersResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from LinkedIn.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
