package com.temboo.Library.LastFm.Tasteometer;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CompareArtists

Retrieves a Tasteometer score from two artist inputs.
*/
public class CompareArtists extends Choreography {

	/**
	Create a new instance of the CompareArtists Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CompareArtists(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LastFm/Tasteometer/CompareArtists"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CompareArtistsInputSet
	*/
	public CompareArtistsInputSet newInputSet() {
		return new CompareArtistsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CompareArtistsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CompareArtistsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CompareArtists
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CompareArtistsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (string) Your Last.fm API Key.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Artist1 input for this Choreo. 

		@param String - (string) The first artist to compare.
		*/
		public void set_Artist1(String value) {
			this.setInput("Artist1", value);
		}


		/** 
		Set the value of the Artist2 input for this Choreo. 

		@param String - (string) The second artist to compare.
		*/
		public void set_Artist2(String value) {
			this.setInput("Artist2", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) How many shared artists to display. Defaults to 5.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) How many shared artists to display. Defaults to 5.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CompareArtists Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CompareArtistsResultSet extends ResultSet {
		public CompareArtistsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (XML) The response from Last.fm.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
