package com.temboo.Library.LastFm.Album;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddTags

Tags an album using a list of user supplied tags. 
*/
public class AddTags extends Choreography {

	/**
	Create a new instance of the AddTags Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddTags(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LastFm/Album/AddTags"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddTagsInputSet
	*/
	public AddTagsInputSet newInputSet() {
		return new AddTagsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddTagsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddTagsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddTags
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddTagsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (string) Your Last.fm API Key.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (string) Your Last.fm API Secret.
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the Album input for this Choreo. 

		@param String - (string) The album name.
		*/
		public void set_Album(String value) {
			this.setInput("Album", value);
		}


		/** 
		Set the value of the Artist input for this Choreo. 

		@param String - (string) The artist name.
		*/
		public void set_Artist(String value) {
			this.setInput("Artist", value);
		}


		/** 
		Set the value of the SessionKey input for this Choreo. 

		@param String - (string) The session key retrieved in the last step of the authorization process.
		*/
		public void set_SessionKey(String value) {
			this.setInput("SessionKey", value);
		}


		/** 
		Set the value of the Tags input for this Choreo. 

		@param String - (string) A comma delimited list of user supplied tags to apply to this album. Accepts a maximum of 10 tags.
		*/
		public void set_Tags(String value) {
			this.setInput("Tags", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddTags Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddTagsResultSet extends ResultSet {
		public AddTagsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (XML) The response from Last.fm.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
