package com.temboo.Library.KhanAcademy.Users;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetUserExercises

Retrieves data about all excercises engaged by a specific user.
*/
public class GetUserExercises extends Choreography {

	/**
	Create a new instance of the GetUserExercises Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetUserExercises(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/KhanAcademy/Users/GetUserExercises"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetUserExercisesInputSet
	*/
	public GetUserExercisesInputSet newInputSet() {
		return new GetUserExercisesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetUserExercisesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetUserExercisesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetUserExercises
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetUserExercisesInputSet extends InputSet {
		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The Consumer Key provided by Khan Academy.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The OAuth Consumer Secret provided by Khan Academy.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (optional, string) The email address (coach or student ID) of user. If not provided, defaults to currently logged in user.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the OAuthToken input for this Choreo. 

		@param String - (required, string) The OAuth Token retrieved during the OAuth process.
		*/
		public void set_OAuthToken(String value) {
			this.setInput("OAuthToken", value);
		}


		/** 
		Set the value of the OAuthTokenSecret input for this Choreo. 

		@param String - (required, string) The OAuth Token Secret retrieved during the OAuth process.
		*/
		public void set_OAuthTokenSecret(String value) {
			this.setInput("OAuthTokenSecret", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetUserExercises Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetUserExercisesResultSet extends ResultSet {
		public GetUserExercisesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Khan Academy.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
