package com.temboo.Library.InfluenceExplorer;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FederalGrants

Returns information about federal grants awarded.
*/
public class FederalGrants extends Choreography {

	/**
	Create a new instance of the FederalGrants Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FederalGrants(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/InfluenceExplorer/FederalGrants"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FederalGrantsInputSet
	*/
	public FederalGrantsInputSet newInputSet() {
		return new FederalGrantsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FederalGrantsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FederalGrantsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FederalGrants
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FederalGrantsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API key provided by Sunlight Data Services.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AgencyName input for this Choreo. 

		@param String - (optional, string) Full-text search on the reported name of the federal agency awarding the grant.
		*/
		public void set_AgencyName(String value) {
			this.setInput("AgencyName", value);
		}


		/** 
		Set the value of the Amount input for this Choreo. 

		@param String - (optional, string) The grant amount. Valid formats include: 500 (exactly $500); >|500 (greater than, or equal to 500); <|500 (less than or equal to 500).
		*/
		public void set_Amount(String value) {
			this.setInput("Amount", value);
		}


		/** 
		Set the value of the AssistanceType input for this Choreo. 

		@param Integer - (optional, integer) A numeric code for the type of grant awarded. See documentation for more details for this parameter.
		*/
		public void set_AssistanceType(Integer value) {
			this.setInput("AssistanceType", value);
		}

		/** 
		Set the value of the AssistanceType input for this Choreo as a String. 

		@param String - (optional, integer) A numeric code for the type of grant awarded. See documentation for more details for this parameter.
		*/
		public void set_AssistanceType(String value) {
			this.setInput("AssistanceType", value);	
		}
		/** 
		Set the value of the FiscalYear input for this Choreo. 

		@param String - (optional, date) The year in which the grant was awarded. A YYYY formatted year. You can also specify a range by separating years with a pipe (i.e. 2008|2012).
		*/
		public void set_FiscalYear(String value) {
			this.setInput("FiscalYear", value);
		}


		/** 
		Set the value of the RecipientName input for this Choreo. 

		@param String - (optional, string) Full-text search on the reported name of the grant recipient.
		*/
		public void set_RecipientName(String value) {
			this.setInput("RecipientName", value);
		}


		/** 
		Set the value of the RecipientState input for this Choreo. 

		@param String - (optional, string) Two-letter abbreviation of the state in which the grant was awarded.
		*/
		public void set_RecipientState(String value) {
			this.setInput("RecipientState", value);
		}


		/** 
		Set the value of the RecipientType input for this Choreo. 

		@param Integer - (optional, integer) The numeric code representing the type of entity that received the grant. See documentation for more details about this parameter.
		*/
		public void set_RecipientType(Integer value) {
			this.setInput("RecipientType", value);
		}

		/** 
		Set the value of the RecipientType input for this Choreo as a String. 

		@param String - (optional, integer) The numeric code representing the type of entity that received the grant. See documentation for more details about this parameter.
		*/
		public void set_RecipientType(String value) {
			this.setInput("RecipientType", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Indicates the desired format for the response. Accepted values are: json (the default), csv, and xls. Note when specifying xls, restults are returned as Base64 encoded data.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FederalGrants Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FederalGrantsResultSet extends ResultSet {
		public FederalGrantsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Influence Explorer. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
