package com.temboo.Library.Google.Gmailv2.Messages;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetLatestMessage

Retrieves the latest email from a user's inbox.
*/
public class GetLatestMessage extends Choreography {

	/**
	Create a new instance of the GetLatestMessage Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetLatestMessage(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Gmailv2/Messages/GetLatestMessage"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetLatestMessageInputSet
	*/
	public GetLatestMessageInputSet newInputSet() {
		return new GetLatestMessageInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetLatestMessageResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetLatestMessageResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetLatestMessage
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetLatestMessageInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid Access Token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the EncodeMessage input for this Choreo. 

		@param Boolean - (optional, boolean) When set to "true" (the default), the message Body will be Base64 encoded.
		*/
		public void set_EncodeMessage(Boolean value) {
			this.setInput("EncodeMessage", value);
		}

		/** 
		Set the value of the EncodeMessage input for this Choreo as a String. 

		@param String - (optional, boolean) When set to "true" (the default), the message Body will be Base64 encoded.
		*/
		public void set_EncodeMessage(String value) {
			this.setInput("EncodeMessage", value);	
		}
		/** 
		Set the value of the IncludeSpamTrash input for this Choreo. 

		@param Boolean - (optional, boolean) Set to "true" to include messages from SPAM and TRASH in the results. Defaults to "false".
		*/
		public void set_IncludeSpamTrash(Boolean value) {
			this.setInput("IncludeSpamTrash", value);
		}

		/** 
		Set the value of the IncludeSpamTrash input for this Choreo as a String. 

		@param String - (optional, boolean) Set to "true" to include messages from SPAM and TRASH in the results. Defaults to "false".
		*/
		public void set_IncludeSpamTrash(String value) {
			this.setInput("IncludeSpamTrash", value);	
		}
		/** 
		Set the value of the LabelID input for this Choreo. 

		@param String - (optional, string) Returns messages with a label matching this ID.
		*/
		public void set_LabelID(String value) {
			this.setInput("LabelID", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the StartHistoryID input for this Choreo. 

		@param String - (optional, string) Returns history records after the specified marker. The history ID is returned by this Choreo after retrieving a message.
		*/
		public void set_StartHistoryID(String value) {
			this.setInput("StartHistoryID", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (optional, string) The ID of the acting user. Defaults to "me" indicating the user associated with the Access Token or Refresh Token provided.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetLatestMessage Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetLatestMessageResultSet extends ResultSet {
		public GetLatestMessageResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Body" output from this Choreo execution

		@return String - (string) The message body.
		*/
		public String get_Body() {
			return this.getResultString("Body");
		}
		/** 
		Retrieve the value for the "From" output from this Choreo execution

		@return String - (string) The sender address.
		*/
		public String get_From() {
			return this.getResultString("From");
		}
		/** 
		Retrieve the value for the "HistoryID" output from this Choreo execution

		@return String - (string) The history ID. This can be passed to the StartHistoryID input to retrieve only mail received after this marker.
		*/
		public String get_HistoryID() {
			return this.getResultString("HistoryID");
		}
		/** 
		Retrieve the value for the "MessageID" output from this Choreo execution

		@return String - (string) The ID of the message.
		*/
		public String get_MessageID() {
			return this.getResultString("MessageID");
		}
		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Snippet" output from this Choreo execution

		@return String - (string) The email body snippet.
		*/
		public String get_Snippet() {
			return this.getResultString("Snippet");
		}
		/** 
		Retrieve the value for the "Subject" output from this Choreo execution

		@return String - (string) The message subject.
		*/
		public String get_Subject() {
			return this.getResultString("Subject");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
