package com.temboo.Library.Genability.TariffData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTariff

Returns an individual Tariff object with a given id.
*/
public class GetTariff extends Choreography {

	/**
	Create a new instance of the GetTariff Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTariff(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Genability/TariffData/GetTariff"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTariffInputSet
	*/
	public GetTariffInputSet newInputSet() {
		return new GetTariffInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTariffResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTariffResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTariff
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTariffInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (conditional, string) The App ID provided by Genability.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Genability.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the MasterTariffID input for this Choreo. 

		@param Integer - (required, integer) The master tariff id. This can be retrieved in the output of the GetTariffs Choreo.
		*/
		public void set_MasterTariffID(Integer value) {
			this.setInput("MasterTariffID", value);
		}

		/** 
		Set the value of the MasterTariffID input for this Choreo as a String. 

		@param String - (required, integer) The master tariff id. This can be retrieved in the output of the GetTariffs Choreo.
		*/
		public void set_MasterTariffID(String value) {
			this.setInput("MasterTariffID", value);	
		}
		/** 
		Set the value of the PopulateProperties input for this Choreo. 

		@param Boolean - (optional, boolean) Set to "true" to populate the properties for the returned Tariffs.
		*/
		public void set_PopulateProperties(Boolean value) {
			this.setInput("PopulateProperties", value);
		}

		/** 
		Set the value of the PopulateProperties input for this Choreo as a String. 

		@param String - (optional, boolean) Set to "true" to populate the properties for the returned Tariffs.
		*/
		public void set_PopulateProperties(String value) {
			this.setInput("PopulateProperties", value);	
		}
		/** 
		Set the value of the PopulateRates input for this Choreo. 

		@param Boolean - (optional, boolean) Set to "true" to populate the rate details for the returned Tariffs.
		*/
		public void set_PopulateRates(Boolean value) {
			this.setInput("PopulateRates", value);
		}

		/** 
		Set the value of the PopulateRates input for this Choreo as a String. 

		@param String - (optional, boolean) Set to "true" to populate the rate details for the returned Tariffs.
		*/
		public void set_PopulateRates(String value) {
			this.setInput("PopulateRates", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTariff Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTariffResultSet extends ResultSet {
		public GetTariffResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Genability.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
