package com.temboo.Library.Flickr.Photos;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListPublicPhotos

Obtain a list of public photos for a given user.
*/
public class ListPublicPhotos extends Choreography {

	/**
	Create a new instance of the ListPublicPhotos Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListPublicPhotos(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Flickr/Photos/ListPublicPhotos"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListPublicPhotosInputSet
	*/
	public ListPublicPhotosInputSet newInputSet() {
		return new ListPublicPhotosInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListPublicPhotosResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListPublicPhotosResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListPublicPhotos
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListPublicPhotosInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Flickr (AKA the OAuth Consumer Key).
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Extras input for this Choreo. 

		@param String - (optional, string) A comma-separated list returning additional photo information such as: license, description, date_upload, date_taken.  Additional options are listed on this method's API doc page.
		*/
		public void set_Extras(String value) {
			this.setInput("Extras", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) Specify the page of photos that is to be returned.  If unspecified, the first page is returned.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) Specify the page of photos that is to be returned.  If unspecified, the first page is returned.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the PerPage input for this Choreo. 

		@param Integer - (optional, integer) Specify how many photos to display per page. Default is set to: 100. The mamimum allowed value is: 500.
		*/
		public void set_PerPage(Integer value) {
			this.setInput("PerPage", value);
		}

		/** 
		Set the value of the PerPage input for this Choreo as a String. 

		@param String - (optional, integer) Specify how many photos to display per page. Default is set to: 100. The mamimum allowed value is: 500.
		*/
		public void set_PerPage(String value) {
			this.setInput("PerPage", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml and json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SafeSearch input for this Choreo. 

		@param Integer - (optional, integer) Specify a safe search setting by entering: 1 (for safe), 2 (moderate), 3 (restricted).  Default is set to: 1 (safe).
		*/
		public void set_SafeSearch(Integer value) {
			this.setInput("SafeSearch", value);
		}

		/** 
		Set the value of the SafeSearch input for this Choreo as a String. 

		@param String - (optional, integer) Specify a safe search setting by entering: 1 (for safe), 2 (moderate), 3 (restricted).  Default is set to: 1 (safe).
		*/
		public void set_SafeSearch(String value) {
			this.setInput("SafeSearch", value);	
		}
		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (required, string) Enter the NSID of the user whose public photos are being retrieved.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListPublicPhotos Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListPublicPhotosResultSet extends ResultSet {
		public ListPublicPhotosResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Flickr.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
