package com.temboo.Library.EnviroFacts.UVForecast;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DailyUVByZipCode

Retrieves EPA daily Ultraviolet (UV) Index readings in a given zip code. 
*/
public class DailyUVByZipCode extends Choreography {

	/**
	Create a new instance of the DailyUVByZipCode Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DailyUVByZipCode(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/EnviroFacts/UVForecast/DailyUVByZipCode"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DailyUVByZipCodeInputSet
	*/
	public DailyUVByZipCodeInputSet newInputSet() {
		return new DailyUVByZipCodeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DailyUVByZipCodeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DailyUVByZipCodeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DailyUVByZipCode
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DailyUVByZipCodeInputSet extends InputSet {
		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Results can be retrieved in either JSON or XML. Defaults to XML.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


		/** 
		Set the value of the Zip input for this Choreo. 

		@param Integer - (required, integer) A valid United States Postal Service (USPS) ZIP Code or Postal Code.
		*/
		public void set_Zip(Integer value) {
			this.setInput("Zip", value);
		}

		/** 
		Set the value of the Zip input for this Choreo as a String. 

		@param String - (required, integer) A valid United States Postal Service (USPS) ZIP Code or Postal Code.
		*/
		public void set_Zip(String value) {
			this.setInput("Zip", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DailyUVByZipCode Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DailyUVByZipCodeResultSet extends ResultSet {
		public DailyUVByZipCodeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from EnviroFacts.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
