package com.temboo.Library.Dwolla.Contacts;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
NearbyContacts

Retrieves nearby Dwolla spots within the range of the provided latitude and longitude.
*/
public class NearbyContacts extends Choreography {

	/**
	Create a new instance of the NearbyContacts Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public NearbyContacts(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dwolla/Contacts/NearbyContacts"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return NearbyContactsInputSet
	*/
	public NearbyContactsInputSet newInputSet() {
		return new NearbyContactsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public NearbyContactsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new NearbyContactsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the NearbyContacts
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class NearbyContactsInputSet extends InputSet {
		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (required, string) The Client ID provided by Dwolla (AKA the Consumer Key).
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (required, string) The Client Secret provided by Dwolla (AKA the Consumer Secret).
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) Current latitude.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) Current latitude.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Number of spots to retrieve. Defaults to 10.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Number of spots to retrieve. Defaults to 10.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) Current longitude.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) Current longitude.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the Range input for this Choreo. 

		@param Integer - (optional, integer) Range to retrieve spots for in miles.
		*/
		public void set_Range(Integer value) {
			this.setInput("Range", value);
		}

		/** 
		Set the value of the Range input for this Choreo as a String. 

		@param String - (optional, integer) Range to retrieve spots for in miles.
		*/
		public void set_Range(String value) {
			this.setInput("Range", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the NearbyContacts Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class NearbyContactsResultSet extends ResultSet {
		public NearbyContactsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Dwolla.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
