package com.temboo.Library.Dropbox.Users;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetAccount

Retrieves information about a user's account.
*/
public class GetAccount extends Choreography {

	/**
	Create a new instance of the GetAccount Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetAccount(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/Users/GetAccount"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetAccountInputSet
	*/
	public GetAccountInputSet newInputSet() {
		return new GetAccountInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetAccountResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetAccountResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetAccount
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetAccountInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token for a specific Dropbox user.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccountID input for this Choreo. 

		@param String - (required, string) A user's account identifier.
		*/
		public void set_AccountID(String value) {
			this.setInput("AccountID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetAccount Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetAccountResultSet extends ResultSet {
		public GetAccountResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

	}
	
}
