package com.temboo.Library.Disqus.Forums;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListUsers

Retrieve a list of active users within a forum.
*/
public class ListUsers extends Choreography {

	/**
	Create a new instance of the ListUsers Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListUsers(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Disqus/Forums/ListUsers"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListUsersInputSet
	*/
	public ListUsersInputSet newInputSet() {
		return new ListUsersInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListUsersResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListUsersResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListUsers
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListUsersInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid OAuth 2.0 access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Cursor input for this Choreo. 

		@param String - (optional, string) Default is set to null.
		*/
		public void set_Cursor(String value) {
			this.setInput("Cursor", value);
		}


		/** 
		Set the value of the Forum input for this Choreo. 

		@param String - (required, string) Forum Short Name (i.e., the subdomain of the Disqus Site URL).  Displays all users contained in that  forum.  If null, users from all forums moderated by the authenticating user will be retrieved.
		*/
		public void set_Forum(String value) {
			this.setInput("Forum", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of records to return. Defaults to 25.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of records to return. Defaults to 25.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Order input for this Choreo. 

		@param String - (optional, string) The sort order of the results. Valid values are: asc or desc. Default is set to: asc.
		*/
		public void set_Order(String value) {
			this.setInput("Order", value);
		}


		/** 
		Set the value of the PublicKey input for this Choreo. 

		@param String - (required, string) The Public Key provided by Disqus (AKA the API Key).
		*/
		public void set_PublicKey(String value) {
			this.setInput("PublicKey", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default), jsonp, or rss.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SinceID input for this Choreo. 

		@param String - (optional, string) A Unix timestamp (or ISO datetime standard) to obtain results from. (e.g. 2014-02-02T01:01:00Z) Default is set to null.
		*/
		public void set_SinceID(String value) {
			this.setInput("SinceID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListUsers Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListUsersResultSet extends ResultSet {
		public ListUsersResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Disqus.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
