package com.temboo.Library.Amazon.S3;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PutBucketCORS

Sets the CORS (Cross-Origin Resource Sharing) configuration for a specified bucket.
*/
public class PutBucketCORS extends Choreography {

	/**
	Create a new instance of the PutBucketCORS Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PutBucketCORS(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/S3/PutBucketCORS"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PutBucketCORSInputSet
	*/
	public PutBucketCORSInputSet newInputSet() {
		return new PutBucketCORSInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PutBucketCORSResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PutBucketCORSResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PutBucketCORS
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PutBucketCORSInputSet extends InputSet {
		/** 
		Set the value of the CORSConfiguration input for this Choreo. 

		@param String - (optional, xml) The CORS Configuration XML containing one or more CORS Rules for advanced configuration. If provided the Choreo will ignore all other inputs except your AWS Key/Secret and BucketName.
		*/
		public void set_CORSConfiguration(String value) {
			this.setInput("CORSConfiguration", value);
		}


		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the AllowedHeader input for this Choreo. 

		@param String - (optional, string) Specifies which headers are allowed in a pre-flight OPTIONS request via the Access-Control-Request-Headers header.
		*/
		public void set_AllowedHeader(String value) {
			this.setInput("AllowedHeader", value);
		}


		/** 
		Set the value of the AllowedMethod input for this Choreo. 

		@param String - (conditional, string) The HTTP verb that you want to allow the origin to execute. Valid values are: GET, PUT, HEAD, POST, DELETE.
		*/
		public void set_AllowedMethod(String value) {
			this.setInput("AllowedMethod", value);
		}


		/** 
		Set the value of the AllowedOrigin input for this Choreo. 

		@param String - (conditional, string) An origin that you want to allow cross-domain requests from. This can contain at most one * wild character (i.e. http://*.example.com).
		*/
		public void set_AllowedOrigin(String value) {
			this.setInput("AllowedOrigin", value);
		}


		/** 
		Set the value of the BucketName input for this Choreo. 

		@param String - (required, string) The name of the bucket to set a CORS configuration for.
		*/
		public void set_BucketName(String value) {
			this.setInput("BucketName", value);
		}


		/** 
		Set the value of the ExposeHeader input for this Choreo. 

		@param String - (optional, string) A header in the response that you want customers to be able to access from their applications.
		*/
		public void set_ExposeHeader(String value) {
			this.setInput("ExposeHeader", value);
		}


		/** 
		Set the value of the ID input for this Choreo. 

		@param String - (optional, string) A unique identifier for the rule. The ID value can be up to 255 characters long.
		*/
		public void set_ID(String value) {
			this.setInput("ID", value);
		}


		/** 
		Set the value of the MaxAgeSeconds input for this Choreo. 

		@param Integer - (optional, integer) The time in seconds that your browser is to cache the preflight response for the specified resource.
		*/
		public void set_MaxAgeSeconds(Integer value) {
			this.setInput("MaxAgeSeconds", value);
		}

		/** 
		Set the value of the MaxAgeSeconds input for this Choreo as a String. 

		@param String - (optional, integer) The time in seconds that your browser is to cache the preflight response for the specified resource.
		*/
		public void set_MaxAgeSeconds(String value) {
			this.setInput("MaxAgeSeconds", value);	
		}
		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (required, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PutBucketCORS Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PutBucketCORSResultSet extends ResultSet {
		public PutBucketCORSResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon. Note that for a successful exection, this API operation returns an empty 200 response.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
