package com.temboo.Library.eBay.Trading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetUser

Retrieves data pertaining to a single eBay user.
*/
public class GetUser extends Choreography {

	/**
	Create a new instance of the GetUser Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetUser(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/eBay/Trading/GetUser"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetUserInputSet
	*/
	public GetUserInputSet newInputSet() {
		return new GetUserInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetUserResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetUserResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetUser
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetUserInputSet extends InputSet {
		/** 
		Set the value of the DetailLevel input for this Choreo. 

		@param String - (optional, string) The level of detail to return in the response. Valid values are: ReturnAll or ReturnSummary.
		*/
		public void set_DetailLevel(String value) {
			this.setInput("DetailLevel", value);
		}


		/** 
		Set the value of the IncludeFeatureEligibility input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not to include feature eligibility information in the response. Set to true or false.
		*/
		public void set_IncludeFeatureEligibility(Boolean value) {
			this.setInput("IncludeFeatureEligibility", value);
		}

		/** 
		Set the value of the IncludeFeatureEligibility input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not to include feature eligibility information in the response. Set to true or false.
		*/
		public void set_IncludeFeatureEligibility(String value) {
			this.setInput("IncludeFeatureEligibility", value);	
		}
		/** 
		Set the value of the ItemID input for this Choreo. 

		@param String - (optional, string) The ID of the item of a successfully concluded listing in which the requestor and target user were participants as buyer and seller.
		*/
		public void set_ItemID(String value) {
			this.setInput("ItemID", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SandboxMode input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(Boolean value) {
			this.setInput("SandboxMode", value);
		}

		/** 
		Set the value of the SandboxMode input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(String value) {
			this.setInput("SandboxMode", value);	
		}
		/** 
		Set the value of the SiteID input for this Choreo. 

		@param String - (optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (optional, string) The eBay User ID for the user whose data you want to retrieve.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


		/** 
		Set the value of the UserToken input for this Choreo. 

		@param String - (required, string) A valid eBay Auth Token.
		*/
		public void set_UserToken(String value) {
			this.setInput("UserToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetUser Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetUserResultSet extends ResultSet {
		public GetUserResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from eBay.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
