package com.temboo.Library.YouTube.Search;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListSearchResults

Returns a list of search results that match the specified query parameters.
*/
public class ListSearchResults extends Choreography {

	/**
	Create a new instance of the ListSearchResults Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListSearchResults(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/YouTube/Search/ListSearchResults"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListSearchResultsInputSet
	*/
	public ListSearchResultsInputSet newInputSet() {
		return new ListSearchResultsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListSearchResultsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListSearchResultsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListSearchResults
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListSearchResultsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ChannelID input for this Choreo. 

		@param String - (optional, string) Indicates that the response should only contain resources created by this channel.
		*/
		public void set_ChannelID(String value) {
			this.setInput("ChannelID", value);
		}


		/** 
		Set the value of the ChannelType input for this Choreo. 

		@param String - (optional, string) Restricts a search to a particular type of channel. Valid values are: "any" (returns all channels) and "show" (only retrieves shows).
		*/
		public void set_ChannelType(String value) {
			this.setInput("ChannelType", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (optional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (optional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the MaxResults input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of results to return.
		*/
		public void set_MaxResults(Integer value) {
			this.setInput("MaxResults", value);
		}

		/** 
		Set the value of the MaxResults input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of results to return.
		*/
		public void set_MaxResults(String value) {
			this.setInput("MaxResults", value);	
		}
		/** 
		Set the value of the Order input for this Choreo. 

		@param String - (optional, string) Indicates how the results are sorted. Valid values are: date, rating, relevance, and viewCount.
		*/
		public void set_Order(String value) {
			this.setInput("Order", value);
		}


		/** 
		Set the value of the PageToken input for this Choreo. 

		@param String - (optional, string) The "nextPageToken" found in the response which is used to page through results.
		*/
		public void set_PageToken(String value) {
			this.setInput("PageToken", value);
		}


		/** 
		Set the value of the Part input for this Choreo. 

		@param String - (optional, string) Specifies a comma-separated list of one or more search resource properties that the API response will include. Part names that you can pass are 'id' and 'snippet' (the default).
		*/
		public void set_Part(String value) {
			this.setInput("Part", value);
		}


		/** 
		Set the value of the PublishedAfter input for this Choreo. 

		@param String - (optional, date) Returns only results created after the specified time (formatted as a RFC 3339 date-time i.e. 1970-01-01T00:00:00Z).
		*/
		public void set_PublishedAfter(String value) {
			this.setInput("PublishedAfter", value);
		}


		/** 
		Set the value of the PublishedBefore input for this Choreo. 

		@param String - (optional, date) Returns only results created before the specified time (formatted as a RFC 3339 date-time i.e. 1970-01-01T00:00:00Z).
		*/
		public void set_PublishedBefore(String value) {
			this.setInput("PublishedBefore", value);
		}


		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (conditional, string) A query string for searching videos.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (optional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the RegionCode input for this Choreo. 

		@param String - (optional, string) Returns results for the specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
		*/
		public void set_RegionCode(String value) {
			this.setInput("RegionCode", value);
		}


		/** 
		Set the value of the RelatedToVideoID input for this Choreo. 

		@param String - (optional, string) Retrieves a list of videos that are related to this video id. When using this parameter, the Type parameter must be set to video.
		*/
		public void set_RelatedToVideoID(String value) {
			this.setInput("RelatedToVideoID", value);
		}


		/** 
		Set the value of the TopicID input for this Choreo. 

		@param String - (optional, string) Returns only results associated with the specified topic.
		*/
		public void set_TopicID(String value) {
			this.setInput("TopicID", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (optional, string) Restricts a search query to only retrieve a particular type of resource. The default value is: video,channel,playlist.
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


		/** 
		Set the value of the VideoCaption input for this Choreo. 

		@param String - (optional, string) Returns filtered results based on whether videos have captions. Valid values are: any (the default), closedCaption (only returns videos with captions), or none (only returns videos without captions).
		*/
		public void set_VideoCaption(String value) {
			this.setInput("VideoCaption", value);
		}


		/** 
		Set the value of the VideoCategoryID input for this Choreo. 

		@param String - (optional, string) Filters video search results based on their category.
		*/
		public void set_VideoCategoryID(String value) {
			this.setInput("VideoCategoryID", value);
		}


		/** 
		Set the value of the VideoDefinition input for this Choreo. 

		@param String - (optional, string) Filters video results based high or standard definition. Valid values are: any, high, or standard.
		*/
		public void set_VideoDefinition(String value) {
			this.setInput("VideoDefinition", value);
		}


		/** 
		Set the value of the VideoDimension input for this Choreo. 

		@param String - (optional, string) Restrict a search to only retrieve 2D or 3D videos. Valid values are: 2d, 3d, or any.
		*/
		public void set_VideoDimension(String value) {
			this.setInput("VideoDimension", value);
		}


		/** 
		Set the value of the VideoDuration input for this Choreo. 

		@param String - (optional, string) Filters search results based on the video duration. Valid values are: any, long, medium, and short.
		*/
		public void set_VideoDuration(String value) {
			this.setInput("VideoDuration", value);
		}


		/** 
		Set the value of the VideoEmbeddable input for this Choreo. 

		@param String - (optional, string) Filters search results to include only videos that can be embedded into a webpage. Valid values are: any (the default) or true (which will enable this filter).
		*/
		public void set_VideoEmbeddable(String value) {
			this.setInput("VideoEmbeddable", value);
		}


		/** 
		Set the value of the VideoLicense input for this Choreo. 

		@param String - (optional, string) Filters search results to only include videos with a particular license. Valid values are: any, creativeCommon, and youtube.
		*/
		public void set_VideoLicense(String value) {
			this.setInput("VideoLicense", value);
		}


		/** 
		Set the value of the VideoSyndicated input for this Choreo. 

		@param String - (optional, string) Filters search results for videos that can be played outside of youtube.com. Valid values are: any (the default) or true (which will enable this filter).
		*/
		public void set_VideoSyndicated(String value) {
			this.setInput("VideoSyndicated", value);
		}


		/** 
		Set the value of the VideoType input for this Choreo. 

		@param String - (optional, string) Filters search results to a particular type of videos. Valid values are: any, episode, and movie.
		*/
		public void set_VideoType(String value) {
			this.setInput("VideoType", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListSearchResults Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListSearchResultsResultSet extends ResultSet {
		public ListSearchResultsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from YouTube.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
