package com.temboo.Library.Yahoo.Finance;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetStockQuote

Retrieves information for the specified stock symbol from Yahoo Finance.
*/
public class GetStockQuote extends Choreography {

	/**
	Create a new instance of the GetStockQuote Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetStockQuote(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Yahoo/Finance/GetStockQuote"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetStockQuoteInputSet
	*/
	public GetStockQuoteInputSet newInputSet() {
		return new GetStockQuoteInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetStockQuoteResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetStockQuoteResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetStockQuote
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetStockQuoteInputSet extends InputSet {
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the StockSymbol input for this Choreo. 

		@param String - (required, string) The stock ticker symbol to search for (e.g., AAPL, GOOG, etc).
		*/
		public void set_StockSymbol(String value) {
			this.setInput("StockSymbol", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetStockQuote Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetStockQuoteResultSet extends ResultSet {
		public GetStockQuoteResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Ask" output from this Choreo execution

		@return String - (decimal) The asking price.
		*/
		public String get_Ask() {
			return this.getResultString("Ask");
		}
		/** 
		Retrieve the value for the "Bid" output from this Choreo execution

		@return String - (decimal) The bid price.
		*/
		public String get_Bid() {
			return this.getResultString("Bid");
		}
		/** 
		Retrieve the value for the "Change" output from this Choreo execution

		@return String - (string) The change in the stock price.
		*/
		public String get_Change() {
			return this.getResultString("Change");
		}
		/** 
		Retrieve the value for the "DaysHigh" output from this Choreo execution

		@return String - (decimal) The high price of the day.
		*/
		public String get_DaysHigh() {
			return this.getResultString("DaysHigh");
		}
		/** 
		Retrieve the value for the "DaysLow" output from this Choreo execution

		@return String - (decimal) The low price of the day.
		*/
		public String get_DaysLow() {
			return this.getResultString("DaysLow");
		}
		/** 
		Retrieve the value for the "LastTradePriceOnly" output from this Choreo execution

		@return String - (decimal) The last trade price.
		*/
		public String get_LastTradePriceOnly() {
			return this.getResultString("LastTradePriceOnly");
		}
		/** 
		Retrieve the value for the "Open" output from this Choreo execution

		@return String - (decimal) The price when the market last opened.
		*/
		public String get_Open() {
			return this.getResultString("Open");
		}
		/** 
		Retrieve the value for the "PreviousClose" output from this Choreo execution

		@return String - (decimal) The previous closing price.
		*/
		public String get_PreviousClose() {
			return this.getResultString("PreviousClose");
		}
		/** 
		Retrieve the value for the "Volume" output from this Choreo execution

		@return String - (integer) The volume traded.
		*/
		public String get_Volume() {
			return this.getResultString("Volume");
		}
		/** 
		Retrieve the value for the "YearHigh" output from this Choreo execution

		@return String - (decimal) The price for the year high.
		*/
		public String get_YearHigh() {
			return this.getResultString("YearHigh");
		}
		/** 
		Retrieve the value for the "YearLow" output from this Choreo execution

		@return String - (decimal) The price for the year low.
		*/
		public String get_YearLow() {
			return this.getResultString("YearLow");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Yahoo Finance.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
