package com.temboo.Library.Xively.Devices;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ActivateDevice

Activates (or reactivates) a device given an authorization code. Returns the device API Key and Feed ID. 
*/
public class ActivateDevice extends Choreography {

	/**
	Create a new instance of the ActivateDevice Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ActivateDevice(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/Devices/ActivateDevice"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ActivateDeviceInputSet
	*/
	public ActivateDeviceInputSet newInputSet() {
		return new ActivateDeviceInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ActivateDeviceResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ActivateDeviceResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ActivateDevice
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ActivateDeviceInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (optional, string) Not required for first activation. If re-activating a device, either the original device APIKey returned from the first activation or the master APIKey is required.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ActivationCode input for this Choreo. 

		@param String - (required, string) Activation code provided when pre-registering a device with a serial number.
		*/
		public void set_ActivationCode(String value) {
			this.setInput("ActivationCode", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ActivateDevice Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ActivateDeviceResultSet extends ResultSet {
		public ActivateDeviceResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Xively. Upon successful activation, it returns a JSON array containing the device APIKey, FeedID and Datastreams.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
