package com.temboo.Library.Wordnik.WordList;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DeleteWordList

Deletes a given word list.
*/
public class DeleteWordList extends Choreography {

	/**
	Create a new instance of the DeleteWordList Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DeleteWordList(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Wordnik/WordList/DeleteWordList"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeleteWordListInputSet
	*/
	public DeleteWordListInputSet newInputSet() {
		return new DeleteWordListInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeleteWordListResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeleteWordListResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DeleteWordList
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeleteWordListInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from Wordnik.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, string) The Password of the Wordnik account.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) The Username of the Wordnik account.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


		/** 
		Set the value of the WordList input for this Choreo. 

		@param String - (required, string) The perma-link of the WordLIst to delete.
		*/
		public void set_WordList(String value) {
			this.setInput("WordList", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DeleteWordList Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeleteWordListResultSet extends ResultSet {
		public DeleteWordListResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Wordnik.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
