package com.temboo.Library.Utilities.Text;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GenerateGUID

Obtain a unique, randomly generated ID or GUID (Globally Unique Identifier).
*/
public class GenerateGUID extends Choreography {

	/**
	Create a new instance of the GenerateGUID Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GenerateGUID(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Text/GenerateGUID"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GenerateGUIDInputSet
	*/
	public GenerateGUIDInputSet newInputSet() {
		return new GenerateGUIDInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GenerateGUIDResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GenerateGUIDResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GenerateGUID
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GenerateGUIDInputSet extends InputSet {
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GenerateGUID Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GenerateGUIDResultSet extends ResultSet {
		public GenerateGUIDResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "GUID" output from this Choreo execution

		@return String - (string) The generated GUID.
		*/
		public String get_GUID() {
			return this.getResultString("GUID");
		}
	}
	
}
