package com.temboo.Library.Utilities.Numbers;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GenerateRandom

This choreo generates a random number in a variety of ranges. 
*/
public class GenerateRandom extends Choreography {

	/**
	Create a new instance of the GenerateRandom Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GenerateRandom(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Numbers/GenerateRandom"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GenerateRandomInputSet
	*/
	public GenerateRandomInputSet newInputSet() {
		return new GenerateRandomInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GenerateRandomResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GenerateRandomResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GenerateRandom
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GenerateRandomInputSet extends InputSet {
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GenerateRandom Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GenerateRandomResultSet extends ResultSet {
		public GenerateRandomResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "SignedDecimal" output from this Choreo execution

		@return String - (decimal) Signed Decimal in the range of  -0.5 to +0.5.
		*/
		public String get_SignedDecimal() {
			return this.getResultString("SignedDecimal");
		}
		/** 
		Retrieve the value for the "SignedInteger" output from this Choreo execution

		@return String - (integer) SIgned Integer in the range of -2147483648 through 2147483647.
		*/
		public String get_SignedInteger() {
			return this.getResultString("SignedInteger");
		}
		/** 
		Retrieve the value for the "UnsignedDecimal" output from this Choreo execution

		@return String - (decimal) Unsigned Decimal in the range of 0.0 to 1.0.
		*/
		public String get_UnsignedDecimal() {
			return this.getResultString("UnsignedDecimal");
		}
		/** 
		Retrieve the value for the "UnsignedInteger" output from this Choreo execution

		@return String - (integer) Unsigned integer in the range of 0 through 4294967295.
		*/
		public String get_UnsignedInteger() {
			return this.getResultString("UnsignedInteger");
		}
	}
	
}
