package com.temboo.Library.Utilities.Dates;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetDate

Formats a specified timestamp, or generates the current date in a desired format.
*/
public class GetDate extends Choreography {

	/**
	Create a new instance of the GetDate Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetDate(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Dates/GetDate"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetDateInputSet
	*/
	public GetDateInputSet newInputSet() {
		return new GetDateInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetDateResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetDateResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetDate
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetDateInputSet extends InputSet {
		/** 
		Set the value of the AddDays input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of days to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddDays(Integer value) {
			this.setInput("AddDays", value);
		}

		/** 
		Set the value of the AddDays input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of days to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddDays(String value) {
			this.setInput("AddDays", value);	
		}
		/** 
		Set the value of the AddHours input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of hours to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddHours(Integer value) {
			this.setInput("AddHours", value);
		}

		/** 
		Set the value of the AddHours input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of hours to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddHours(String value) {
			this.setInput("AddHours", value);	
		}
		/** 
		Set the value of the AddMinutes input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of minutes to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddMinutes(Integer value) {
			this.setInput("AddMinutes", value);
		}

		/** 
		Set the value of the AddMinutes input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of minutes to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddMinutes(String value) {
			this.setInput("AddMinutes", value);	
		}
		/** 
		Set the value of the AddMonths input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of months to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddMonths(Integer value) {
			this.setInput("AddMonths", value);
		}

		/** 
		Set the value of the AddMonths input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of months to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddMonths(String value) {
			this.setInput("AddMonths", value);	
		}
		/** 
		Set the value of the AddSeconds input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of seconds to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddSeconds(Integer value) {
			this.setInput("AddSeconds", value);
		}

		/** 
		Set the value of the AddSeconds input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of seconds to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddSeconds(String value) {
			this.setInput("AddSeconds", value);	
		}
		/** 
		Set the value of the AddYears input for this Choreo. 

		@param Integer - (optional, integer) Adds the specified number of years to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddYears(Integer value) {
			this.setInput("AddYears", value);
		}

		/** 
		Set the value of the AddYears input for this Choreo as a String. 

		@param String - (optional, integer) Adds the specified number of years to the specified date serial number. A negative number will subtract.
		*/
		public void set_AddYears(String value) {
			this.setInput("AddYears", value);	
		}
		/** 
		Set the value of the Format input for this Choreo. 

		@param String - (conditional, string) The format that the timestamp should be in. Java SimpleDateFormat conventions are supported. Defaults to "yyyy-MM-dd HH:mm:ss".
		*/
		public void set_Format(String value) {
			this.setInput("Format", value);
		}


		/** 
		Set the value of the LocaleCountry input for this Choreo. 

		@param String - (optional, string) An ISO country code to specify locale.
		*/
		public void set_LocaleCountry(String value) {
			this.setInput("LocaleCountry", value);
		}


		/** 
		Set the value of the LocaleLanguage input for this Choreo. 

		@param String - (optional, string) An ISO language code to specify locale.
		*/
		public void set_LocaleLanguage(String value) {
			this.setInput("LocaleLanguage", value);
		}


		/** 
		Set the value of the LocaleVariant input for this Choreo. 

		@param String - (optional, string) A local variant code such as "NY" to add additional context for a locale.
		*/
		public void set_LocaleVariant(String value) {
			this.setInput("LocaleVariant", value);
		}


		/** 
		Set the value of the SetDay input for this Choreo. 

		@param Integer - (optional, integer) Sets the day of month (1-31) of the specified date serial number.
		*/
		public void set_SetDay(Integer value) {
			this.setInput("SetDay", value);
		}

		/** 
		Set the value of the SetDay input for this Choreo as a String. 

		@param String - (optional, integer) Sets the day of month (1-31) of the specified date serial number.
		*/
		public void set_SetDay(String value) {
			this.setInput("SetDay", value);	
		}
		/** 
		Set the value of the SetHour input for this Choreo. 

		@param Integer - (optional, integer) Sets the hours (0-23) of the specified date serial number.
		*/
		public void set_SetHour(Integer value) {
			this.setInput("SetHour", value);
		}

		/** 
		Set the value of the SetHour input for this Choreo as a String. 

		@param String - (optional, integer) Sets the hours (0-23) of the specified date serial number.
		*/
		public void set_SetHour(String value) {
			this.setInput("SetHour", value);	
		}
		/** 
		Set the value of the SetMinute input for this Choreo. 

		@param Integer - (optional, integer) Sets the minutes (0-59) of the specified date serial number.
		*/
		public void set_SetMinute(Integer value) {
			this.setInput("SetMinute", value);
		}

		/** 
		Set the value of the SetMinute input for this Choreo as a String. 

		@param String - (optional, integer) Sets the minutes (0-59) of the specified date serial number.
		*/
		public void set_SetMinute(String value) {
			this.setInput("SetMinute", value);	
		}
		/** 
		Set the value of the SetMonth input for this Choreo. 

		@param Integer - (optional, integer) Sets the month (1-12) of the specified date serial number.
		*/
		public void set_SetMonth(Integer value) {
			this.setInput("SetMonth", value);
		}

		/** 
		Set the value of the SetMonth input for this Choreo as a String. 

		@param String - (optional, integer) Sets the month (1-12) of the specified date serial number.
		*/
		public void set_SetMonth(String value) {
			this.setInput("SetMonth", value);	
		}
		/** 
		Set the value of the SetSecond input for this Choreo. 

		@param Integer - (optional, integer) Sets the seconds (0-59) of the specified date serial number.
		*/
		public void set_SetSecond(Integer value) {
			this.setInput("SetSecond", value);
		}

		/** 
		Set the value of the SetSecond input for this Choreo as a String. 

		@param String - (optional, integer) Sets the seconds (0-59) of the specified date serial number.
		*/
		public void set_SetSecond(String value) {
			this.setInput("SetSecond", value);	
		}
		/** 
		Set the value of the SetYear input for this Choreo. 

		@param Integer - (optional, integer) Sets the year (such as 1989) of the specified date serial number.
		*/
		public void set_SetYear(Integer value) {
			this.setInput("SetYear", value);
		}

		/** 
		Set the value of the SetYear input for this Choreo as a String. 

		@param String - (optional, integer) Sets the year (such as 1989) of the specified date serial number.
		*/
		public void set_SetYear(String value) {
			this.setInput("SetYear", value);	
		}
		/** 
		Set the value of the TimeZone input for this Choreo. 

		@param String - (optional, string) The timezone to use for the date formatting function. Defaults to UTC.
		*/
		public void set_TimeZone(String value) {
			this.setInput("TimeZone", value);
		}


		/** 
		Set the value of the Timestamp input for this Choreo. 

		@param String - (conditional, date) A number representing the desired formatted date and time, expressed as the number of milliseconds since January 1, 1970 (epoch time). If not provided, this defaults to NOW().
		*/
		public void set_Timestamp(String value) {
			this.setInput("Timestamp", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetDate Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetDateResultSet extends ResultSet {
		public GetDateResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "FormattedDate" output from this Choreo execution

		@return String - (date) The formatted version of the timestamp.
		*/
		public String get_FormattedDate() {
			return this.getResultString("FormattedDate");
		}
	}
	
}
