package com.temboo.Library.Twitter.Tweets;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
StatusesUpdate

Allows you to update your Twitter status (aka Tweet).
*/
public class StatusesUpdate extends Choreography {

	/**
	Create a new instance of the StatusesUpdate Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public StatusesUpdate(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twitter/Tweets/StatusesUpdate"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return StatusesUpdateInputSet
	*/
	public StatusesUpdateInputSet newInputSet() {
		return new StatusesUpdateInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public StatusesUpdateResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new StatusesUpdateResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the StatusesUpdate
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class StatusesUpdateInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The API Key (or Consumer Key) provided by Twitter.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The API Secret (or Consumer Secret) provided by Twitter.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the DisplayCoordinates input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not to put a pin on the exact coordinates a tweet has been sent from.
		*/
		public void set_DisplayCoordinates(Boolean value) {
			this.setInput("DisplayCoordinates", value);
		}

		/** 
		Set the value of the DisplayCoordinates input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not to put a pin on the exact coordinates a tweet has been sent from.
		*/
		public void set_DisplayCoordinates(String value) {
			this.setInput("DisplayCoordinates", value);	
		}
		/** 
		Set the value of the InReplyTo input for this Choreo. 

		@param String - (optional, string) The ID of an existing status that the update is in reply to.
		*/
		public void set_InReplyTo(String value) {
			this.setInput("InReplyTo", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) The latitude of the location this tweet refers to e.g., 40.71863.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (optional, decimal) The latitude of the location this tweet refers to e.g., 40.71863.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) The longitude of the location this tweet refers to e.g., -74.005584.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (optional, decimal) The longitude of the location this tweet refers to e.g., -74.005584.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the PlaceID input for this Choreo. 

		@param String - (optional, string) The ID associated with a place in the world. These IDs can be retrieved from the PlacesAndGeo.ReverseGeocode Choreo.
		*/
		public void set_PlaceID(String value) {
			this.setInput("PlaceID", value);
		}


		/** 
		Set the value of the PossiblySensitive input for this Choreo. 

		@param Boolean - (optional, boolean) Set to true for content which may not be suitable for every audience.
		*/
		public void set_PossiblySensitive(Boolean value) {
			this.setInput("PossiblySensitive", value);
		}

		/** 
		Set the value of the PossiblySensitive input for this Choreo as a String. 

		@param String - (optional, boolean) Set to true for content which may not be suitable for every audience.
		*/
		public void set_PossiblySensitive(String value) {
			this.setInput("PossiblySensitive", value);	
		}
		/** 
		Set the value of the StatusUpdate input for this Choreo. 

		@param String - (required, string) The text for your status update. 140-character limit.
		*/
		public void set_StatusUpdate(String value) {
			this.setInput("StatusUpdate", value);
		}


		/** 
		Set the value of the TrimUser input for this Choreo. 

		@param Boolean - (optional, boolean) When set to either true, each tweet returned in a timeline will include a user object including only the status authors numerical ID.
		*/
		public void set_TrimUser(Boolean value) {
			this.setInput("TrimUser", value);
		}

		/** 
		Set the value of the TrimUser input for this Choreo as a String. 

		@param String - (optional, boolean) When set to either true, each tweet returned in a timeline will include a user object including only the status authors numerical ID.
		*/
		public void set_TrimUser(String value) {
			this.setInput("TrimUser", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the StatusesUpdate Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class StatusesUpdateResultSet extends ResultSet {
		public StatusesUpdateResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Twitter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
