package com.temboo.Library.Twilio.Calls;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CaptureKeyPadEntry

Initiates a call from the specified Twilio account and returns a key pad entry.
*/
public class CaptureKeyPadEntry extends Choreography {

	/**
	Create a new instance of the CaptureKeyPadEntry Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CaptureKeyPadEntry(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twilio/Calls/CaptureKeyPadEntry"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CaptureKeyPadEntryInputSet
	*/
	public CaptureKeyPadEntryInputSet newInputSet() {
		return new CaptureKeyPadEntryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CaptureKeyPadEntryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CaptureKeyPadEntryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CaptureKeyPadEntry
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CaptureKeyPadEntryInputSet extends InputSet {
		/** 
		Set the value of the AccountSID input for this Choreo. 

		@param String - (required, string) The AccountSID provided when you signed up for a Twilio account.
		*/
		public void set_AccountSID(String value) {
			this.setInput("AccountSID", value);
		}


		/** 
		Set the value of the AnswerURL input for this Choreo. 

		@param String - (conditional, string) The URL for the Twiml file containing your Temboo Callback URL. See Choreo notes below.
		*/
		public void set_AnswerURL(String value) {
			this.setInput("AnswerURL", value);
		}


		/** 
		Set the value of the AuthToken input for this Choreo. 

		@param String - (required, string) The authorization token provided when you signed up for a Twilio account.
		*/
		public void set_AuthToken(String value) {
			this.setInput("AuthToken", value);
		}


		/** 
		Set the value of the From input for this Choreo. 

		@param String - (required, string) The Twilio phone number or client identifier to use as the caller id.
		*/
		public void set_From(String value) {
			this.setInput("From", value);
		}


		/** 
		Set the value of the GoodbyeURL input for this Choreo. 

		@param String - (required, string) The URL for the Twiml file that contains a "goodbye" message that will be evalated after a Twilio webhook event. This is an optional input that can be used when passing the AnswerURL.
		*/
		public void set_GoodbyeURL(String value) {
			this.setInput("GoodbyeURL", value);
		}


		/** 
		Set the value of the IfMachine input for this Choreo. 

		@param String - (optional, string) Indicates if Twilio should to try and determine if a machine (like voicemail) or a human has answered the call. Possible values are "Continue" and "Hangup".
		*/
		public void set_IfMachine(String value) {
			this.setInput("IfMachine", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SubAccountSID input for this Choreo. 

		@param String - (optional, string) The SID of the subaccount associated with this call. If not specified, the main AccountSID used to authenticate is used in request.
		*/
		public void set_SubAccountSID(String value) {
			this.setInput("SubAccountSID", value);
		}


		/** 
		Set the value of the Timeout input for this Choreo. 

		@param Integer - (optional, integer) The integer number of seconds that Twilio should allow the phone to ring before assuming there is no answer. Default is 60 seconds, the maximum is 999 seconds.
		*/
		public void set_Timeout(Integer value) {
			this.setInput("Timeout", value);
		}

		/** 
		Set the value of the Timeout input for this Choreo as a String. 

		@param String - (optional, integer) The integer number of seconds that Twilio should allow the phone to ring before assuming there is no answer. Default is 60 seconds, the maximum is 999 seconds.
		*/
		public void set_Timeout(String value) {
			this.setInput("Timeout", value);	
		}
		/** 
		Set the value of the To input for this Choreo. 

		@param String - (required, string) The phone number or client identifier to call.
		*/
		public void set_To(String value) {
			this.setInput("To", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CaptureKeyPadEntry Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CaptureKeyPadEntryResultSet extends ResultSet {
		public CaptureKeyPadEntryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "CallbackData" output from this Choreo execution

		@return String - (string) The Twilio callback data retrieved after a user has entered a pin code.
		*/
		public String get_CallbackData() {
			return this.getResultString("CallbackData");
		}
		/** 
		Retrieve the value for the "Digits" output from this Choreo execution

		@return String - (integer) The digits that the call recipient entered into the keypad after receiving the call from Twilio.
		*/
		public String get_Digits() {
			return this.getResultString("Digits");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Twilio.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
