package com.temboo.Library.SunlightLabs.CapitolWords;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Phrases

Returns a list of the top phrases in the Congressional Record, which are searchable by day, month, state, or legislator.
*/
public class Phrases extends Choreography {

	/**
	Create a new instance of the Phrases Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Phrases(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/SunlightLabs/CapitolWords/Phrases"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PhrasesInputSet
	*/
	public PhrasesInputSet newInputSet() {
		return new PhrasesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PhrasesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PhrasesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Phrases
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PhrasesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Sunlight Labs.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Chamber input for this Choreo. 

		@param String - (optional, string) Limit results to a particular chamber. Valid values: house, senate, extensions.
		*/
		public void set_Chamber(String value) {
			this.setInput("Chamber", value);
		}


		/** 
		Set the value of the Date input for this Choreo. 

		@param String - (optional, string) Show results for only the given date. Format: YYYY-MM-DD
		*/
		public void set_Date(String value) {
			this.setInput("Date", value);
		}


		/** 
		Set the value of the EndDate input for this Choreo. 

		@param String - (optional, string) Limit results to those on or before the given date. Format: YYYY-MM-DD.
		*/
		public void set_EndDate(String value) {
			this.setInput("EndDate", value);
		}


		/** 
		Set the value of the EntityType input for this Choreo. 

		@param String - (required, string) The entity type to get top phrases for. Acceptable values: date, month, state, legislator.
		*/
		public void set_EntityType(String value) {
			this.setInput("EntityType", value);
		}


		/** 
		Set the value of the EntityValue input for this Choreo. 

		@param String - (required, string) The value of the entity to get top phrases for. Acceptable formats as follows for each EntityType: (date) 2011-11-09, (month) 201111, (state) NY. For the legislator EntityType, enter Bioguide ID here.
		*/
		public void set_EntityValue(String value) {
			this.setInput("EntityValue", value);
		}


		/** 
		Set the value of the Length input for this Choreo. 

		@param Integer - (optional, integer) The length of the phrase, in words, to search for (up to 5).
		*/
		public void set_Length(Integer value) {
			this.setInput("Length", value);
		}

		/** 
		Set the value of the Length input for this Choreo as a String. 

		@param String - (optional, integer) The length of the phrase, in words, to search for (up to 5).
		*/
		public void set_Length(String value) {
			this.setInput("Length", value);	
		}
		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page of results to show. 100 results are shown at a time. To see more results use the page parameter.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page of results to show. 100 results are shown at a time. To see more results use the page parameter.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the Party input for this Choreo. 

		@param String - (optional, string) Limit results to members of congress from a given party. Valid values: R, D, I.
		*/
		public void set_Party(String value) {
			this.setInput("Party", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Output formats inlcude json and xml. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, string) The metric and direction to sort by. Acceptable values: tfidf asc (default), tfidf desc, count asc, count desc.
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


		/** 
		Set the value of the StartDate input for this Choreo. 

		@param String - (optional, string) Limit results to those on or after the given date. Format: YYYY-MM-DD
		*/
		public void set_StartDate(String value) {
			this.setInput("StartDate", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) Limit results to members from a particular state. Format: 2-letter state abbreviation (e.g. MD, RI, NY)
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Phrases Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PhrasesResultSet extends ResultSet {
		public PhrasesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from CapitolWords.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
