package com.temboo.Library.Stripe.Coupons;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateCoupon

Creates a coupon that can be redeemed by customers for a discount.
*/
public class CreateCoupon extends Choreography {

	/**
	Create a new instance of the CreateCoupon Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateCoupon(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Stripe/Coupons/CreateCoupon"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateCouponInputSet
	*/
	public CreateCouponInputSet newInputSet() {
		return new CreateCouponInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateCouponResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateCouponResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateCoupon
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateCouponInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Stripe
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the CouponID input for this Choreo. 

		@param String - (optional, string) The unique identifier of your choice for the coupon. If not specified, a random code will be generated by Stripe.
		*/
		public void set_CouponID(String value) {
			this.setInput("CouponID", value);
		}


		/** 
		Set the value of the Duration input for this Choreo. 

		@param String - (required, string) Indicates how long the discount will be in effect. Valid values are: forever, once, repeating.
		*/
		public void set_Duration(String value) {
			this.setInput("Duration", value);
		}


		/** 
		Set the value of the DurationInMonths input for this Choreo. 

		@param Integer - (optional, integer) If Duration is set to 'repeating', specify the number of months the discount will be valid.
		*/
		public void set_DurationInMonths(Integer value) {
			this.setInput("DurationInMonths", value);
		}

		/** 
		Set the value of the DurationInMonths input for this Choreo as a String. 

		@param String - (optional, integer) If Duration is set to 'repeating', specify the number of months the discount will be valid.
		*/
		public void set_DurationInMonths(String value) {
			this.setInput("DurationInMonths", value);	
		}
		/** 
		Set the value of the MaxRedemptions input for this Choreo. 

		@param Integer - (optional, integer) Specify the number times the coupon can be used.
		*/
		public void set_MaxRedemptions(Integer value) {
			this.setInput("MaxRedemptions", value);
		}

		/** 
		Set the value of the MaxRedemptions input for this Choreo as a String. 

		@param String - (optional, integer) Specify the number times the coupon can be used.
		*/
		public void set_MaxRedemptions(String value) {
			this.setInput("MaxRedemptions", value);	
		}
		/** 
		Set the value of the PercentOff input for this Choreo. 

		@param Integer - (required, integer) A integer between 1 and 100 that represents the discount that the coupon will apply when used by a customer
		*/
		public void set_PercentOff(Integer value) {
			this.setInput("PercentOff", value);
		}

		/** 
		Set the value of the PercentOff input for this Choreo as a String. 

		@param String - (required, integer) A integer between 1 and 100 that represents the discount that the coupon will apply when used by a customer
		*/
		public void set_PercentOff(String value) {
			this.setInput("PercentOff", value);	
		}
		/** 
		Set the value of the RedeemBy input for this Choreo. 

		@param String - (optional, date) An epoch timestamp in seconds representing the the last time at which the coupon can be used. Specify timestamp in UTC.
		*/
		public void set_RedeemBy(String value) {
			this.setInput("RedeemBy", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateCoupon Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateCouponResultSet extends ResultSet {
		public CreateCouponResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Stripe
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
