package com.temboo.Library.Stripe.Charges;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RetrieveCharge

Retrieves the details of an existing charge.
*/
public class RetrieveCharge extends Choreography {

	/**
	Create a new instance of the RetrieveCharge Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RetrieveCharge(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Stripe/Charges/RetrieveCharge"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RetrieveChargeInputSet
	*/
	public RetrieveChargeInputSet newInputSet() {
		return new RetrieveChargeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RetrieveChargeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RetrieveChargeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RetrieveCharge
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RetrieveChargeInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Stripe
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ChargeID input for this Choreo. 

		@param String - (required, string) The unique identifier of the charge you want to retrieve
		*/
		public void set_ChargeID(String value) {
			this.setInput("ChargeID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RetrieveCharge Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RetrieveChargeResultSet extends ResultSet {
		public RetrieveChargeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Stripe
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
