package com.temboo.Library.Pusher.Events;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PostEvent

Triggers an event on one or more channels.
*/
public class PostEvent extends Choreography {

	/**
	Create a new instance of the PostEvent Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PostEvent(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Pusher/Events/PostEvent"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PostEventInputSet
	*/
	public PostEventInputSet newInputSet() {
		return new PostEventInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PostEventResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PostEventResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PostEvent
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PostEventInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) The application ID provided by Pusher.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The authenticaion key provided by Pusher.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the AppSecret input for this Choreo. 

		@param String - (required, string) The authentication secret provided by Pusher.
		*/
		public void set_AppSecret(String value) {
			this.setInput("AppSecret", value);
		}


		/** 
		Set the value of the ChannelName input for this Choreo. 

		@param String - (required, string) The name of the channel to publish to. This can also be a list of channels formatted as a JSON array.
		*/
		public void set_ChannelName(String value) {
			this.setInput("ChannelName", value);
		}


		/** 
		Set the value of the EventData input for this Choreo. 

		@param String - (required, json) A JSON object containing the event data.
		*/
		public void set_EventData(String value) {
			this.setInput("EventData", value);
		}


		/** 
		Set the value of the EventName input for this Choreo. 

		@param String - (required, string) The name of the event being triggered.
		*/
		public void set_EventName(String value) {
			this.setInput("EventName", value);
		}


		/** 
		Set the value of the SocketID input for this Choreo. 

		@param String - (optional, string) Excludes the event from being sent to a specific connection.
		*/
		public void set_SocketID(String value) {
			this.setInput("SocketID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PostEvent Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PostEventResultSet extends ResultSet {
		public PostEventResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Pusher. A successful request returns an empty JSON hash.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
