package com.temboo.Library.Plotly;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PlotBarGraph

Plots an array of points on a bar graph.
*/
public class PlotBarGraph extends Choreography {

	/**
	Create a new instance of the PlotBarGraph Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PlotBarGraph(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Plotly/PlotBarGraph"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PlotBarGraphInputSet
	*/
	public PlotBarGraphInputSet newInputSet() {
		return new PlotBarGraphInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PlotBarGraphResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PlotBarGraphResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PlotBarGraph
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PlotBarGraphInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Plotly.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the FileName input for this Choreo. 

		@param String - (required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).
		*/
		public void set_FileName(String value) {
			this.setInput("FileName", value);
		}


		/** 
		Set the value of the FileOption input for this Choreo. 

		@param String - (optional, string) The file operation being performed. Valid values are: "new", "overwrite", "append", or "extend". See Choreo description for more details. This defaults to "overwrite".
		*/
		public void set_FileOption(String value) {
			this.setInput("FileOption", value);
		}


		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (optional, string) The title of the graph.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) A valid Plotly username.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


		/** 
		Set the value of the WorldReadable input for this Choreo. 

		@param Boolean - (optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
		*/
		public void set_WorldReadable(Boolean value) {
			this.setInput("WorldReadable", value);
		}

		/** 
		Set the value of the WorldReadable input for this Choreo as a String. 

		@param String - (optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
		*/
		public void set_WorldReadable(String value) {
			this.setInput("WorldReadable", value);	
		}
		/** 
		Set the value of the XValues input for this Choreo. 

		@param String - (required, json) A JSON array containing the "x" coordinate values to be plotted on the graph.
		*/
		public void set_XValues(String value) {
			this.setInput("XValues", value);
		}


		/** 
		Set the value of the YValues input for this Choreo. 

		@param String - (required, json) A JSON array containing the "y" coordinate values to be plotted on the graph.
		*/
		public void set_YValues(String value) {
			this.setInput("YValues", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PlotBarGraph Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PlotBarGraphResultSet extends ResultSet {
		public PlotBarGraphResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "URL" output from this Choreo execution

		@return String - (string) The Plotly URL for the graph.
		*/
		public String get_URL() {
			return this.getResultString("URL");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Plotly
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
