package com.temboo.Library.Nexmo.SMS;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SendMessage

Send a text message to any global number.
*/
public class SendMessage extends Choreography {

	/**
	Create a new instance of the SendMessage Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SendMessage(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Nexmo/SMS/SendMessage"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SendMessageInputSet
	*/
	public SendMessageInputSet newInputSet() {
		return new SendMessageInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SendMessageResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SendMessageResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SendMessage
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SendMessageInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) Your API Key provided to you by Nexmo.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (required, string) Your API Secret provided to you by Nexmo.
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the Body input for this Choreo. 

		@param String - (optional, string) Hex encoded binary data. (e.g. 0011223344556677).  Required when Type is binary.
		*/
		public void set_Body(String value) {
			this.setInput("Body", value);
		}


		/** 
		Set the value of the CallbackID input for this Choreo. 

		@param String - (conditional, string) A unique identifier that is part of your Temboo callback URL registered at Nexmo. Required in order to listen for a reply. See Choreo description for details.
		*/
		public void set_CallbackID(String value) {
			this.setInput("CallbackID", value);
		}


		/** 
		Set the value of the ClientReference input for this Choreo. 

		@param String - (optional, string) Include a note for your reference. (40 characters max).
		*/
		public void set_ClientReference(String value) {
			this.setInput("ClientReference", value);
		}


		/** 
		Set the value of the DeliveryReceipt input for this Choreo. 

		@param Integer - (optional, integer) Set to 1 to receive a Delivery Receipt for this message. Make sure to configure your "Callback URL" in your "API Settings".
		*/
		public void set_DeliveryReceipt(Integer value) {
			this.setInput("DeliveryReceipt", value);
		}

		/** 
		Set the value of the DeliveryReceipt input for this Choreo as a String. 

		@param String - (optional, integer) Set to 1 to receive a Delivery Receipt for this message. Make sure to configure your "Callback URL" in your "API Settings".
		*/
		public void set_DeliveryReceipt(String value) {
			this.setInput("DeliveryReceipt", value);	
		}
		/** 
		Set the value of the From input for this Choreo. 

		@param String - (required, string) The phone number associated with your Nexmo account e.g. 17185551234.
		*/
		public void set_From(String value) {
			this.setInput("From", value);
		}


		/** 
		Set the value of the MessageClass input for this Choreo. 

		@param Integer - (optional, integer) Set to 0 for Flash SMS.
		*/
		public void set_MessageClass(Integer value) {
			this.setInput("MessageClass", value);
		}

		/** 
		Set the value of the MessageClass input for this Choreo as a String. 

		@param String - (optional, integer) Set to 0 for Flash SMS.
		*/
		public void set_MessageClass(String value) {
			this.setInput("MessageClass", value);	
		}
		/** 
		Set the value of the NetworkCode input for this Choreo. 

		@param String - (optional, string) Sends this message to the specifed network operator (MCCMNC).
		*/
		public void set_NetworkCode(String value) {
			this.setInput("NetworkCode", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "json" (the default) and "xml".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the TTL input for this Choreo. 

		@param Integer - (optional, integer) Message life span (Time to  live) in milliseconds.
		*/
		public void set_TTL(Integer value) {
			this.setInput("TTL", value);
		}

		/** 
		Set the value of the TTL input for this Choreo as a String. 

		@param String - (optional, integer) Message life span (Time to  live) in milliseconds.
		*/
		public void set_TTL(String value) {
			this.setInput("TTL", value);	
		}
		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (conditional, string) Required when Type is "text".  Body of the text message (with a maximum length of 3200 characters).
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


		/** 
		Set the value of the Timeout input for this Choreo. 

		@param Integer - (conditional, integer) The amount of time (in minutes) to wait for a reply when a CallbackID is provided. Defaults to 10. See Choreo description for details.
		*/
		public void set_Timeout(Integer value) {
			this.setInput("Timeout", value);
		}

		/** 
		Set the value of the Timeout input for this Choreo as a String. 

		@param String - (conditional, integer) The amount of time (in minutes) to wait for a reply when a CallbackID is provided. Defaults to 10. See Choreo description for details.
		*/
		public void set_Timeout(String value) {
			this.setInput("Timeout", value);	
		}
		/** 
		Set the value of the To input for this Choreo. 

		@param String - (required, string) The mobile number in international format (e.g. 447525856424 or 00447525856424 when sending to UK).
		*/
		public void set_To(String value) {
			this.setInput("To", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (optional, string) This can be omitted for text (default), but is required when sending a Binary (binary), WAP Push (wappush), Unicode message (unicode), VCal (vcal) or VCard (vcard).
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


		/** 
		Set the value of the UDH input for this Choreo. 

		@param String - (optional, string) Hex encoded User data header. (e.g. 06050415811581) (Required when Type is binary).
		*/
		public void set_UDH(String value) {
			this.setInput("UDH", value);
		}


		/** 
		Set the value of the VCal input for this Choreo. 

		@param String - (optional, string) Correctly formatted VCal text body.
		*/
		public void set_VCal(String value) {
			this.setInput("VCal", value);
		}


		/** 
		Set the value of the VCard input for this Choreo. 

		@param String - (optional, string) Correctly formatted VCard text body.
		*/
		public void set_VCard(String value) {
			this.setInput("VCard", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SendMessage Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SendMessageResultSet extends ResultSet {
		public SendMessageResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "CallbackData" output from this Choreo execution

		@return String - The Nexmo callback data retrieved after a user has replied to the SMS message. This is only returned if you've setup your Temboo callback URL at Nexmo, and  have provided the CallbackID input.
		*/
		public String get_CallbackData() {
			return this.getResultString("CallbackData");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Nexmo. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
