package com.temboo.Library.NYTimes.EventListings;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchListings

Searches events by location, filters, or full text search.
*/
public class SearchListings extends Choreography {

	/**
	Create a new instance of the SearchListings Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchListings(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/EventListings/SearchListings"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchListingsInputSet
	*/
	public SearchListingsInputSet newInputSet() {
		return new SearchListingsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchListingsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchListingsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchListings
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchListingsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the DateRange input for this Choreo. 

		@param String - (optional, date) Start date to end date in the following format: YYYY-MM-DD:YYYY-MM-DD.
		*/
		public void set_DateRange(String value) {
			this.setInput("DateRange", value);
		}


		/** 
		Set the value of the Filters input for this Choreo. 

		@param String - (optional, string) Filters search results using facet names and values. See Choreo documentation for examples.
		*/
		public void set_Filters(String value) {
			this.setInput("Filters", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) The latitude coordinate of the location to use in the event search. If specified, Longitude must also be provided.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (optional, decimal) The latitude coordinate of the location to use in the event search. If specified, Longitude must also be provided.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) The longitude coordinate of the location to use in the event search. If specified, Latitude must also be provided.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (optional, decimal) The longitude coordinate of the location to use in the event search. If specified, Latitude must also be provided.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) A numeric value indicating the starting point of the result set. This can be used in combination with the Limit input to page through results.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) A numeric value indicating the starting point of the result set. This can be used in combination with the Limit input to page through results.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (optional, string) Search keywords to perform a text search on the following fields: web_description, event_name and venue_name.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the Radius input for this Choreo. 

		@param Integer - (optional, integer) The radius of the spacial search (in meters). Defaults to 1000.
		*/
		public void set_Radius(Integer value) {
			this.setInput("Radius", value);
		}

		/** 
		Set the value of the Radius input for this Choreo as a String. 

		@param String - (optional, integer) The radius of the spacial search (in meters). Defaults to 1000.
		*/
		public void set_Radius(String value) {
			this.setInput("Radius", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, string) Allows you to sort results. Appending "+asc" or "+desc" to a facet will sort results on that value in ascending or descending order (i.e. dist+asc).
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchListings Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchListingsResultSet extends ResultSet {
		public SearchListingsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API. Format corresponds to the ResponseFormat input. Defaults to xml.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
