package com.temboo.Library.NYTimes.CampaignFinance.Candidates;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CandidateLeadersByCategory

Retrieve a list of the 20 top candidates in terms of contributions received.
*/
public class CandidateLeadersByCategory extends Choreography {

	/**
	Create a new instance of the CandidateLeadersByCategory Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CandidateLeadersByCategory(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/CampaignFinance/Candidates/CandidateLeadersByCategory"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CandidateLeadersByCategoryInputSet
	*/
	public CandidateLeadersByCategoryInputSet newInputSet() {
		return new CandidateLeadersByCategoryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CandidateLeadersByCategoryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CandidateLeadersByCategoryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CandidateLeadersByCategory
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CandidateLeadersByCategoryInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the CampaignCycle input for this Choreo. 

		@param Integer - (required, integer) Enter the campaign cycle year in YYYY format.  This must be an even year.
		*/
		public void set_CampaignCycle(Integer value) {
			this.setInput("CampaignCycle", value);
		}

		/** 
		Set the value of the CampaignCycle input for this Choreo as a String. 

		@param String - (required, integer) Enter the campaign cycle year in YYYY format.  This must be an even year.
		*/
		public void set_CampaignCycle(String value) {
			this.setInput("CampaignCycle", value);	
		}
		/** 
		Set the value of the Category input for this Choreo. 

		@param String - (required, string) Specify thecategory to be retrieved. Example: contribution-total, returns the total amount of financial contributions received by this candidate's campaign.  See Description for more info.
		*/
		public void set_Category(String value) {
			this.setInput("Category", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Enter json or xml.  Default is json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CandidateLeadersByCategory Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CandidateLeadersByCategoryResultSet extends ResultSet {
		public CandidateLeadersByCategoryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API corresponds to the setting (json, or xml) entered in the ResponseFormat variable.  Default is set to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
