package com.temboo.Library.LastFm.Artist;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetCorrection

Allows you to check whether the supplied artist has a correction to a canonical artist.
*/
public class GetCorrection extends Choreography {

	/**
	Create a new instance of the GetCorrection Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetCorrection(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LastFm/Artist/GetCorrection"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetCorrectionInputSet
	*/
	public GetCorrectionInputSet newInputSet() {
		return new GetCorrectionInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetCorrectionResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetCorrectionResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetCorrection
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetCorrectionInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (string) Your Last.fm API Key.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Artist input for this Choreo. 

		@param String - (string) The artist name to correct.
		*/
		public void set_Artist(String value) {
			this.setInput("Artist", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetCorrection Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetCorrectionResultSet extends ResultSet {
		public GetCorrectionResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (XML) The response from Last.fm.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
