package com.temboo.Library.GovTrack;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Vote

Returns roll call votes in the U.S. Congress since 1789.
*/
public class Vote extends Choreography {

	/**
	Create a new instance of the Vote Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Vote(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/GovTrack/Vote"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return VoteInputSet
	*/
	public VoteInputSet newInputSet() {
		return new VoteInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public VoteResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new VoteResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Vote
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class VoteInputSet extends InputSet {
		/** 
		Set the value of the Chamber input for this Choreo. 

		@param String - (optional, string) The chamber in which the vote was held. Valid values are: house or senate. Filter operators allowed but only when filtering by Congress as well. Sortable.
		*/
		public void set_Chamber(String value) {
			this.setInput("Chamber", value);
		}


		/** 
		Set the value of the Congress input for this Choreo. 

		@param String - (optional, string) The number of the congress in which the vote took place. The current congress is 113. Filter operators allowed. Sortable.
		*/
		public void set_Congress(String value) {
			this.setInput("Congress", value);
		}


		/** 
		Set the value of the Created input for this Choreo. 

		@param String - (optional, string) The date (and in recent history also the time) on which the vote was held. Filter operators allowed. Sortable.
		*/
		public void set_Created(String value) {
			this.setInput("Created", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) A comma separated list of fields to return in the response. Use double-underscores to span relationships (e.g. person__firstname).
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Results are paged 100 per call by default. Set the limit input to a high value to get all of the results at once.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Results are paged 100 per call by default. Set the limit input to a high value to get all of the results at once.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Number input for this Choreo. 

		@param String - (optional, string) The number of the vote, unique to a Congress and session pair. Filter operators allowed. Sortable.
		*/
		public void set_Number(String value) {
			this.setInput("Number", value);
		}


		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) Offset the results by the number given, useful for paging through results.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) Offset the results by the number given, useful for paging through results.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the RelatedAmendment input for this Choreo. 

		@param String - (optional, string) The ID of a related amendment. Filter operators allowed. Sortable.
		*/
		public void set_RelatedAmendment(String value) {
			this.setInput("RelatedAmendment", value);
		}


		/** 
		Set the value of the RelatedBill input for this Choreo. 

		@param String - (optional, string) A bill related to this vote. Filter operators allowed. Sortable.
		*/
		public void set_RelatedBill(String value) {
			this.setInput("RelatedBill", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Session input for this Choreo. 

		@param String - (optional, string) The session of congress. Filter operators allowed. Sortable.
		*/
		public void set_Session(String value) {
			this.setInput("Session", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, string) You can order the results using created (ascending) or -created (descending) for the dates that each vote was held.
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


		/** 
		Set the value of the VoteID input for this Choreo. 

		@param Integer - (optional, integer) The ID of a vote object to retrieve. When using this input, all other filter parameters are ignored, and a single record is returned.
		*/
		public void set_VoteID(Integer value) {
			this.setInput("VoteID", value);
		}

		/** 
		Set the value of the VoteID input for this Choreo as a String. 

		@param String - (optional, integer) The ID of a vote object to retrieve. When using this input, all other filter parameters are ignored, and a single record is returned.
		*/
		public void set_VoteID(String value) {
			this.setInput("VoteID", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Vote Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class VoteResultSet extends ResultSet {
		public VoteResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from GovTrack.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
