package com.temboo.Library.Google.Calendar;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateEvent

Create a new event in a specified calendar.
*/
public class CreateEvent extends Choreography {

	/**
	Create a new instance of the CreateEvent Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateEvent(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Calendar/CreateEvent"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateEventInputSet
	*/
	public CreateEventInputSet newInputSet() {
		return new CreateEventInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateEventResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateEventResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateEvent
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateEventInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the CalendarID input for this Choreo. 

		@param String - (required, string) The unique ID for the calendar in which to add the event.  Note that calendar IDs can be retrieved by running GetAllCalendars or SearchCalendarsByName.
		*/
		public void set_CalendarID(String value) {
			this.setInput("CalendarID", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the EndDate input for this Choreo. 

		@param String - (required, string) The end date of the event, in the format "2012-04-10".
		*/
		public void set_EndDate(String value) {
			this.setInput("EndDate", value);
		}


		/** 
		Set the value of the EndTime input for this Choreo. 

		@param String - (required, string) The end time for the event, in the format "10:30:00".
		*/
		public void set_EndTime(String value) {
			this.setInput("EndTime", value);
		}


		/** 
		Set the value of the EventDescription input for this Choreo. 

		@param String - (optional, string) A short description of the event.
		*/
		public void set_EventDescription(String value) {
			this.setInput("EventDescription", value);
		}


		/** 
		Set the value of the EventLocation input for this Choreo. 

		@param String - (optional, string) The location for the new event.
		*/
		public void set_EventLocation(String value) {
			this.setInput("EventLocation", value);
		}


		/** 
		Set the value of the EventTitle input for this Choreo. 

		@param String - (required, string) The title for the new event.
		*/
		public void set_EventTitle(String value) {
			this.setInput("EventTitle", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the StartDate input for this Choreo. 

		@param String - (required, string) The start date of the event, in the format "2012-11-03".
		*/
		public void set_StartDate(String value) {
			this.setInput("StartDate", value);
		}


		/** 
		Set the value of the StartTime input for this Choreo. 

		@param String - (required, string) The start time for the event, in the format "10:00:00".
		*/
		public void set_StartTime(String value) {
			this.setInput("StartTime", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateEvent Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateEventResultSet extends ResultSet {
		public CreateEventResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "TimezoneSetting" output from this Choreo execution

		@return String - (string) The timezone setting retrieved from the specified calendar.
		*/
		public String get_TimezoneSetting() {
			return this.getResultString("TimezoneSetting");
		}
		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
