package com.temboo.Library.Genability.TariffData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetLoadServingEntity

Returns a Load Serving Entity with a given ID.
*/
public class GetLoadServingEntity extends Choreography {

	/**
	Create a new instance of the GetLoadServingEntity Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetLoadServingEntity(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Genability/TariffData/GetLoadServingEntity"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetLoadServingEntityInputSet
	*/
	public GetLoadServingEntityInputSet newInputSet() {
		return new GetLoadServingEntityInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetLoadServingEntityResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetLoadServingEntityResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetLoadServingEntity
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetLoadServingEntityInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (conditional, string) The App ID provided by Genability.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Genability.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the LSEID input for this Choreo. 

		@param Integer - (required, integer) The id of a particular Load Serving Entity to return.
		*/
		public void set_LSEID(Integer value) {
			this.setInput("LSEID", value);
		}

		/** 
		Set the value of the LSEID input for this Choreo as a String. 

		@param String - (required, integer) The id of a particular Load Serving Entity to return.
		*/
		public void set_LSEID(String value) {
			this.setInput("LSEID", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetLoadServingEntity Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetLoadServingEntityResultSet extends ResultSet {
		public GetLoadServingEntityResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Genability.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
