package com.temboo.Library.Foursquare.Checkins;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddPost

Posts user-generated content from an external app to a Foursquare check-in.
*/
public class AddPost extends Choreography {

	/**
	Create a new instance of the AddPost Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddPost(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Checkins/AddPost"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddPostInputSet
	*/
	public AddPostInputSet newInputSet() {
		return new AddPostInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddPostResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddPostResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddPost
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddPostInputSet extends InputSet {
		/** 
		Set the value of the CheckinID input for this Choreo. 

		@param String - (required, string) The ID of the check-in to add a post to.
		*/
		public void set_CheckinID(String value) {
			this.setInput("CheckinID", value);
		}


		/** 
		Set the value of the ContentID input for this Choreo. 

		@param String - (optional, string) An ID for the post to be used in a native link. Can be up to 50 characters. The URL input must also be specified when using this parameter.
		*/
		public void set_ContentID(String value) {
			this.setInput("ContentID", value);
		}


		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (required, string) The Foursquare API OAuth token string.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (required, string) The text of the post. Max length is 200 characters.
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


		/** 
		Set the value of the URL input for this Choreo. 

		@param String - (optional, string) A URL linking to more details. The following URL schemes are supported: http, https, foursquare, mailto, tel, and sms.
		*/
		public void set_URL(String value) {
			this.setInput("URL", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddPost Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddPostResultSet extends ResultSet {
		public AddPostResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
