package com.temboo.Library.Fitbit.OAuth;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RefreshToken

Refreshes an expired access token.
*/
public class RefreshToken extends Choreography {

	/**
	Create a new instance of the RefreshToken Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RefreshToken(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Fitbit/OAuth/RefreshToken"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RefreshTokenInputSet
	*/
	public RefreshTokenInputSet newInputSet() {
		return new RefreshTokenInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RefreshTokenResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RefreshTokenResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RefreshToken
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RefreshTokenInputSet extends InputSet {
		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (required, string) The OAuth 2.0 Client ID provided by the Fitbit.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (required, string) The OAuth 2.0 Client Secret provided by Fitbit.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (required, string) The refresh token retrieved in the OAuth process to be used when your access token expires.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RefreshToken Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RefreshTokenResultSet extends ResultSet {
		public RefreshTokenResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "AccessToken" output from this Choreo execution

		@return String - (string) The Access Token for the user that has granted access to your application.
		*/
		public String get_AccessToken() {
			return this.getResultString("AccessToken");
		}
		/** 
		Retrieve the value for the "Expires" output from this Choreo execution

		@return String - (integer) The remaining lifetime of the short-lived access token.
		*/
		public String get_Expires() {
			return this.getResultString("Expires");
		}
		/** 
		Retrieve the value for the "NewRefreshToken" output from this Choreo execution

		@return String - (string) The new Refresh Token which can be used the next time your app needs to get a new Access Token.
		*/
		public String get_NewRefreshToken() {
			return this.getResultString("NewRefreshToken");
		}
	}
	
}
