package com.temboo.Library.FedSpending;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Recovery

Allows access to the information in the Recovery Act Recipient Reports database.
*/
public class Recovery extends Choreography {

	/**
	Create a new instance of the Recovery Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Recovery(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/FedSpending/Recovery"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RecoveryInputSet
	*/
	public RecoveryInputSet newInputSet() {
		return new RecoveryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RecoveryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RecoveryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Recovery
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RecoveryInputSet extends InputSet {
		/** 
		Set the value of the Activity input for this Choreo. 

		@param String - (conditional, string) Whether or not to search by activity. (Will provide a select list if "y"). y = yes, n = no. Defaults to n if not set.
		*/
		public void set_Activity(String value) {
			this.setInput("Activity", value);
		}


		/** 
		Set the value of the AwardAmount input for this Choreo. 

		@param String - (conditional, string) Grants: total Federal dollars. Loans: face value of loan obligated by the Federal Agency. Contracts: total amount obligated by Federal Agency. Vendors: payment amount. Recipients:  amount of award.
		*/
		public void set_AwardAmount(String value) {
			this.setInput("AwardAmount", value);
		}


		/** 
		Set the value of the AwardNumber input for this Choreo. 

		@param Integer - (conditional, integer) Identifying number assigned by the awarding Federal Agency. e.g. federal grant number, federal contract number or federal loan number. For grants and loans, this is assigned by the prime recipient.
		*/
		public void set_AwardNumber(Integer value) {
			this.setInput("AwardNumber", value);
		}

		/** 
		Set the value of the AwardNumber input for this Choreo as a String. 

		@param String - (conditional, integer) Identifying number assigned by the awarding Federal Agency. e.g. federal grant number, federal contract number or federal loan number. For grants and loans, this is assigned by the prime recipient.
		*/
		public void set_AwardNumber(String value) {
			this.setInput("AwardNumber", value);	
		}
		/** 
		Set the value of the AwardType input for this Choreo. 

		@param String - (conditional, string) Acceptable values: G = Grants only,L = Loans only, C = Contracts only.
		*/
		public void set_AwardType(String value) {
			this.setInput("AwardType", value);
		}


		/** 
		Set the value of the AwardingAgency input for this Choreo. 

		@param String - (conditional, string) The 4-digit code for a specific governmental awarding agency that awarded and is administering the award on behalf of the funding agency.
		*/
		public void set_AwardingAgency(String value) {
			this.setInput("AwardingAgency", value);
		}


		/** 
		Set the value of the CFDA input for this Choreo. 

		@param String - (conditional, string) The Catalog of Federal Domestic Number is the number associated with the published description of a Federal Assistance program in the CFDA.
		*/
		public void set_CFDA(String value) {
			this.setInput("CFDA", value);
		}


		/** 
		Set the value of the Detail input for this Choreo. 

		@param String - (optional, string) Controls the level of detail of the output. Acceptable values: -1 (summary), 0 (low), 1 (medium), 2 (high), and 3 (extensive). Defaults to -1. See docs for more information.
		*/
		public void set_Detail(String value) {
			this.setInput("Detail", value);
		}


		/** 
		Set the value of the EntityDun input for this Choreo. 

		@param String - (conditional, string) The prime recipient for the award's Dun & Bradstreet number (no vendor information).
		*/
		public void set_EntityDun(String value) {
			this.setInput("EntityDun", value);
		}


		/** 
		Set the value of the FirstYearRange input for this Choreo. 

		@param Integer - (conditional, integer) Specifies the first year in a range of years from 2000-2006; if used, must be used with LastYearRange and without FiscalYear.
		*/
		public void set_FirstYearRange(Integer value) {
			this.setInput("FirstYearRange", value);
		}

		/** 
		Set the value of the FirstYearRange input for this Choreo as a String. 

		@param String - (conditional, integer) Specifies the first year in a range of years from 2000-2006; if used, must be used with LastYearRange and without FiscalYear.
		*/
		public void set_FirstYearRange(String value) {
			this.setInput("FirstYearRange", value);	
		}
		/** 
		Set the value of the FiscalYear input for this Choreo. 

		@param Integer - (conditional, integer) Specifies a single year; defaults to all years.
		*/
		public void set_FiscalYear(Integer value) {
			this.setInput("FiscalYear", value);
		}

		/** 
		Set the value of the FiscalYear input for this Choreo as a String. 

		@param String - (conditional, integer) Specifies a single year; defaults to all years.
		*/
		public void set_FiscalYear(String value) {
			this.setInput("FiscalYear", value);	
		}
		/** 
		Set the value of the FundingAgency input for this Choreo. 

		@param String - (conditional, string) The 4-digit code for a specific governmental agency that is responsible for funding/distributing the ARRA funds to recipients.
		*/
		public void set_FundingAgency(String value) {
			this.setInput("FundingAgency", value);
		}


		/** 
		Set the value of the FundingTAS input for this Choreo. 

		@param String - (conditional, string) The Agency Treasury Account Symbol (TAS) that identifies the funding Program Source. The Program Source is based out of the OMB TAS list.
		*/
		public void set_FundingTAS(String value) {
			this.setInput("FundingTAS", value);
		}


		/** 
		Set the value of the GovtContractOffice input for this Choreo. 

		@param String - (conditional, string) The agency supplied code of the government contracting office that executed the transaction. (For prime recipients only.)
		*/
		public void set_GovtContractOffice(String value) {
			this.setInput("GovtContractOffice", value);
		}


		/** 
		Set the value of the LastYearRange input for this Choreo. 

		@param Integer - (conditional, integer) Specifies the last year in a range of years; if used, must be used with FirstYearRange and without FiscalYear.
		*/
		public void set_LastYearRange(Integer value) {
			this.setInput("LastYearRange", value);
		}

		/** 
		Set the value of the LastYearRange input for this Choreo as a String. 

		@param String - (conditional, integer) Specifies the last year in a range of years; if used, must be used with FirstYearRange and without FiscalYear.
		*/
		public void set_LastYearRange(String value) {
			this.setInput("LastYearRange", value);	
		}
		/** 
		Set the value of the MaxRecords input for this Choreo. 

		@param Integer - (optional, integer) Allows you to set the maximum number of records retrieved. Defaults to 100.
		*/
		public void set_MaxRecords(Integer value) {
			this.setInput("MaxRecords", value);
		}

		/** 
		Set the value of the MaxRecords input for this Choreo as a String. 

		@param String - (optional, integer) Allows you to set the maximum number of records retrieved. Defaults to 100.
		*/
		public void set_MaxRecords(String value) {
			this.setInput("MaxRecords", value);	
		}
		/** 
		Set the value of the NumberOfJobs input for this Choreo. 

		@param Integer - (conditional, integer) The number of Full-Time Equivalent (FTE) jobs created and retained.
		*/
		public void set_NumberOfJobs(Integer value) {
			this.setInput("NumberOfJobs", value);
		}

		/** 
		Set the value of the NumberOfJobs input for this Choreo as a String. 

		@param String - (conditional, integer) The number of Full-Time Equivalent (FTE) jobs created and retained.
		*/
		public void set_NumberOfJobs(String value) {
			this.setInput("NumberOfJobs", value);	
		}
		/** 
		Set the value of the OfficerComp input for this Choreo. 

		@param Integer - (conditional, integer) Total compensation of first highly compensated officer.
		*/
		public void set_OfficerComp(Integer value) {
			this.setInput("OfficerComp", value);
		}

		/** 
		Set the value of the OfficerComp input for this Choreo as a String. 

		@param String - (conditional, integer) Total compensation of first highly compensated officer.
		*/
		public void set_OfficerComp(String value) {
			this.setInput("OfficerComp", value);	
		}
		/** 
		Set the value of the OrderNumber input for this Choreo. 

		@param String - (conditional, string) This is an identifying number assigned to the contract.
		*/
		public void set_OrderNumber(String value) {
			this.setInput("OrderNumber", value);
		}


		/** 
		Set the value of the PopCity input for this Choreo. 

		@param String - (conditional, string) The city in which work was performed.
		*/
		public void set_PopCity(String value) {
			this.setInput("PopCity", value);
		}


		/** 
		Set the value of the PopCountry input for this Choreo. 

		@param String - (conditional, string) The two-letter country code for the country in which work was performed.
		*/
		public void set_PopCountry(String value) {
			this.setInput("PopCountry", value);
		}


		/** 
		Set the value of the PopDistrict input for this Choreo. 

		@param String - (conditional, string) The Congressional District in which work was performed.
		*/
		public void set_PopDistrict(String value) {
			this.setInput("PopDistrict", value);
		}


		/** 
		Set the value of the PopState input for this Choreo. 

		@param String - (conditional, string) The two-letter code for the state in which in which work was performed (the "place of performance").
		*/
		public void set_PopState(String value) {
			this.setInput("PopState", value);
		}


		/** 
		Set the value of the PopZip input for this Choreo. 

		@param Integer - (conditional, integer) The ZIP code in which work was performed.
		*/
		public void set_PopZip(Integer value) {
			this.setInput("PopZip", value);
		}

		/** 
		Set the value of the PopZip input for this Choreo as a String. 

		@param String - (conditional, integer) The ZIP code in which work was performed.
		*/
		public void set_PopZip(String value) {
			this.setInput("PopZip", value);	
		}
		/** 
		Set the value of the ProjectDescription input for this Choreo. 

		@param String - (conditional, string) A description of the project under which the award is funded.
		*/
		public void set_ProjectDescription(String value) {
			this.setInput("ProjectDescription", value);
		}


		/** 
		Set the value of the RecipientDistrict input for this Choreo. 

		@param String - (conditional, string) A 4-character numeric designation for the Congressional District within which a recipient or vendor is located. (For prime recipients and sub-recipients only.)
		*/
		public void set_RecipientDistrict(String value) {
			this.setInput("RecipientDistrict", value);
		}


		/** 
		Set the value of the RecipientName input for this Choreo. 

		@param String - (conditional, string) The name of the recipient (prime recipient, sub-recipient, or vendor); value given is used as a text search.
		*/
		public void set_RecipientName(String value) {
			this.setInput("RecipientName", value);
		}


		/** 
		Set the value of the RecipientStateCode input for this Choreo. 

		@param String - (conditional, string) The postal state abbreviation for the state in the recipient's address (can be for prime recipient, sub-recipient, or vendor).
		*/
		public void set_RecipientStateCode(String value) {
			this.setInput("RecipientStateCode", value);
		}


		/** 
		Set the value of the RecipientType input for this Choreo. 

		@param String - (conditional, string) Recipient or vendor type: p = Prime recipients only, s = Sub-recipients only, v = Vendors only.
		*/
		public void set_RecipientType(String value) {
			this.setInput("RecipientType", value);
		}


		/** 
		Set the value of the RecipientZip input for this Choreo. 

		@param Integer - (conditional, integer) The ZIP code of the recipient (prime recipient, sub-recipient, or vendor).
		*/
		public void set_RecipientZip(Integer value) {
			this.setInput("RecipientZip", value);
		}

		/** 
		Set the value of the RecipientZip input for this Choreo as a String. 

		@param String - (conditional, integer) The ZIP code of the recipient (prime recipient, sub-recipient, or vendor).
		*/
		public void set_RecipientZip(String value) {
			this.setInput("RecipientZip", value);	
		}
		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, string) Determines the order in which records are sorted. The default value sorts by Recipient/Vendor Name. See doc for all other values.
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


		/** 
		Set the value of the TextSearch input for this Choreo. 

		@param String - (conditional, string) Full text search.
		*/
		public void set_TextSearch(String value) {
			this.setInput("TextSearch", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Recovery Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RecoveryResultSet extends ResultSet {
		public RecoveryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from FedSpending.org.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
