package com.temboo.Library.DailyMed;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchByName

Returns a list of drugs in the DailyMed database associated with a given drug name.
*/
public class SearchByName extends Choreography {

	/**
	Create a new instance of the SearchByName Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchByName(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/DailyMed/SearchByName"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchByNameInputSet
	*/
	public SearchByNameInputSet newInputSet() {
		return new SearchByNameInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchByNameResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchByNameResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchByName
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchByNameInputSet extends InputSet {
		/** 
		Set the value of the DrugName input for this Choreo. 

		@param String - (required, string) The name of the drug you want to find.
		*/
		public void set_DrugName(String value) {
			this.setInput("DrugName", value);
		}


		/** 
		Set the value of the LabelType input for this Choreo. 

		@param String - (optional, string) Filter results by a specified type. Acceptable values: rxonly, otc, human, human/rxonly, human/otc, animal. See documentation for more information.
		*/
		public void set_LabelType(String value) {
			this.setInput("LabelType", value);
		}


		/** 
		Set the value of the OutputFormat input for this Choreo. 

		@param String - (optional, string) Defaults to XML format when nothing is specified. Acceptable values: xml or json.
		*/
		public void set_OutputFormat(String value) {
			this.setInput("OutputFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchByName Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchByNameResultSet extends ResultSet {
		public SearchByNameResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from DailyMed.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
