package com.temboo.Library.CorpWatch.Lists;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListCountryCodes

Returns a complete list of ISO-3166 standard country and subdivision codes.
*/
public class ListCountryCodes extends Choreography {

	/**
	Create a new instance of the ListCountryCodes Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListCountryCodes(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/CorpWatch/Lists/ListCountryCodes"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListCountryCodesInputSet
	*/
	public ListCountryCodesInputSet newInputSet() {
		return new ListCountryCodesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListCountryCodesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListCountryCodesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListCountryCodes
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListCountryCodesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (optional, string) The APIKey from CorpWatch if you have one.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Index input for this Choreo. 

		@param Integer - (optional, integer) Set the index number of the first result to be returned. The index of the first result is 0.
		*/
		public void set_Index(Integer value) {
			this.setInput("Index", value);
		}

		/** 
		Set the value of the Index input for this Choreo as a String. 

		@param String - (optional, integer) Set the index number of the first result to be returned. The index of the first result is 0.
		*/
		public void set_Index(String value) {
			this.setInput("Index", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of results to be returned. Defaults to 100. Maximum is 5000.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to be returned. Defaults to 100. Maximum is 5000.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Specify json or xml for the type of response to be returned. Defaults to xml.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListCountryCodes Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListCountryCodesResultSet extends ResultSet {
		public ListCountryCodesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from CorpWatch.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
