package com.temboo.Library.Bugzilla;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RetrieveUser

Retrieves information for a specified user.
*/
public class RetrieveUser extends Choreography {

	/**
	Create a new instance of the RetrieveUser Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RetrieveUser(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Bugzilla/RetrieveUser"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RetrieveUserInputSet
	*/
	public RetrieveUserInputSet newInputSet() {
		return new RetrieveUserInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RetrieveUserResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RetrieveUserResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RetrieveUser
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RetrieveUserInputSet extends InputSet {
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (optional, password) Your Bugzilla password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the QueryUserID input for this Choreo. 

		@param String - (required, string) The ID of the user to retrieve information for. Valid input formats include: email address, or numeric user ID. If searching by numeric ID, authentication is requred.
		*/
		public void set_QueryUserID(String value) {
			this.setInput("QueryUserID", value);
		}


		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (optional, string) The base URL for the Bugzilla server to access. Defaults to https://api-dev.bugzilla.mozilla.org/latest. To access the test server, set to https://api-dev.bugzilla.mozilla.org/test/latest.
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (optional, string) Your Bugzilla username.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RetrieveUser Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RetrieveUserResultSet extends ResultSet {
		public RetrieveUserResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Bugzilla.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
