package com.temboo.Library.Bitly.UserInfo;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetUserInfo

Returns information about a specified user.
*/
public class GetUserInfo extends Choreography {

	/**
	Create a new instance of the GetUserInfo Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetUserInfo(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Bitly/UserInfo/GetUserInfo"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetUserInfoInputSet
	*/
	public GetUserInfoInputSet newInputSet() {
		return new GetUserInfoInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetUserInfoResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetUserInfoResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetUserInfo
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetUserInfoInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The OAuth access token provided by Bitly.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the FullName input for this Choreo. 

		@param String - (optional, string) The users full name value (only available for the authenticated user).
		*/
		public void set_FullName(String value) {
			this.setInput("FullName", value);
		}


		/** 
		Set the value of the Login input for this Choreo. 

		@param String - (optional, string) The Bitly login of the user whose info to look up. If not given, the authenticated user will be used.
		*/
		public void set_Login(String value) {
			this.setInput("Login", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that you want the response to be in. Accepted values are "json" or "xml". Defaults to "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetUserInfo Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetUserInfoResultSet extends ResultSet {
		public GetUserInfoResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Bitly.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
