package com.temboo.Library.Amazon.S3;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetBase64EncodedObject

Retrieves a specified item from an Amazon S3 bucket, returns the file content as base64-encoded data, and returns the values of key response headers as output variables if available.
*/
public class GetBase64EncodedObject extends Choreography {

	/**
	Create a new instance of the GetBase64EncodedObject Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetBase64EncodedObject(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/S3/GetBase64EncodedObject"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetBase64EncodedObjectInputSet
	*/
	public GetBase64EncodedObjectInputSet newInputSet() {
		return new GetBase64EncodedObjectInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetBase64EncodedObjectResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetBase64EncodedObjectResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetBase64EncodedObject
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetBase64EncodedObjectInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the BucketName input for this Choreo. 

		@param String - (required, string) The name of the bucket that contains the object to retrieve.
		*/
		public void set_BucketName(String value) {
			this.setInput("BucketName", value);
		}


		/** 
		Set the value of the FileName input for this Choreo. 

		@param String - (required, string) The name of the file to retrieve.
		*/
		public void set_FileName(String value) {
			this.setInput("FileName", value);
		}


		/** 
		Set the value of the IfMatch input for this Choreo. 

		@param String - (optional, string) Returns the object only if its entity tag (ETag) is the same as the one specified, otherwise returns a 412 (precondition failed) error.
		*/
		public void set_IfMatch(String value) {
			this.setInput("IfMatch", value);
		}


		/** 
		Set the value of the IfModifiedSince input for this Choreo. 

		@param String - (optional, date) Returns the object only if it has been modified since the specific time, otherwise returns a 304 (not modified) error.
		*/
		public void set_IfModifiedSince(String value) {
			this.setInput("IfModifiedSince", value);
		}


		/** 
		Set the value of the IfNoneMatch input for this Choreo. 

		@param String - (optional, string) Returns the object only if its entity tag (ETag) is different from the one specified, otherwise retuns a 304 (not modified) error. Will not work correctly with IfModifiedSince.
		*/
		public void set_IfNoneMatch(String value) {
			this.setInput("IfNoneMatch", value);
		}


		/** 
		Set the value of the IfUnmodifiedSince input for this Choreo. 

		@param String - (optional, date) Returns the object only if it has not been modified since the specified time, otherwise returns a 412 (precondition failed) error.
		*/
		public void set_IfUnmodifiedSince(String value) {
			this.setInput("IfUnmodifiedSince", value);
		}


		/** 
		Set the value of the Range input for this Choreo. 

		@param String - (optional, string) Downloads the specific range of bytes of an object. Ex: 0-9 (returns the first 10 bytes of an object), 100-1000, etc. If the range value exceeds the end of file, it will return up to the end of file.
		*/
		public void set_Range(String value) {
			this.setInput("Range", value);
		}


		/** 
		Set the value of the SSECAlgorithm input for this Choreo. 

		@param String - (optional, string) Specifies the server-side encryption with customer-provided encryption keys (SSE-C) algorithm used when Amazon S3 created the target object. Valid value: AES256.
		*/
		public void set_SSECAlgorithm(String value) {
			this.setInput("SSECAlgorithm", value);
		}


		/** 
		Set the value of the SSECKey input for this Choreo. 

		@param String - (optional, string) The customer-provided AES-256 256-bit (32-byte) encryption key for Amazon S3 to use to encrypt or decrypt your data.
		*/
		public void set_SSECKey(String value) {
			this.setInput("SSECKey", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (conditional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetBase64EncodedObject Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetBase64EncodedObjectResultSet extends ResultSet {
		public GetBase64EncodedObjectResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "DeleteMarker" output from this Choreo execution

		@return String - (boolean) Returns true if the object retrieved was a Delete Marker otherwise no value.
		*/
		public String get_DeleteMarker() {
			return this.getResultString("DeleteMarker");
		}
		/** 
		Retrieve the value for the "ETag" output from this Choreo execution

		@return String - (string) The ETag string for the file.
		*/
		public String get_ETag() {
			return this.getResultString("ETag");
		}
		/** 
		Retrieve the value for the "Expiration" output from this Choreo execution

		@return String - (string) Appears if the object expiration is configured. It includes expiry-date and URL-encoded rule-id key value pairs providing object expiration information.
		*/
		public String get_Expiration() {
			return this.getResultString("Expiration");
		}
		/** 
		Retrieve the value for the "Restore" output from this Choreo execution

		@return String - (string) Provides information about the object restoration operation and expiration time of the restored object copy.
		*/
		public String get_Restore() {
			return this.getResultString("Restore");
		}
		/** 
		Retrieve the value for the "ServerSideEncryption" output from this Choreo execution

		@return String - (string) If the object is stored using server-side encryption, response includes this header with value of the encryption algorithm used. Valid Values: AES256.
		*/
		public String get_ServerSideEncryption() {
			return this.getResultString("ServerSideEncryption");
		}
		/** 
		Retrieve the value for the "VersionID" output from this Choreo execution

		@return String - (string) Returns the version ID of the retrieved object if it has a unique version ID.
		*/
		public String get_VersionID() {
			return this.getResultString("VersionID");
		}
		/** 
		Retrieve the value for the "WebsiteRedirectLocation" output from this Choreo execution

		@return String - (string) For a bucket configured as a website, this metadata can be set so the website will evaluate the request for the object as a 301 redirect to another object in the same bucket or an external URL.
		*/
		public String get_WebsiteRedirectLocation() {
			return this.getResultString("WebsiteRedirectLocation");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) The base64-encoded contents of the file you are retrieving.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
